package Field::russian_passport_series;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PartnerInfo
  Type::input
  );

use Utils;

sub _get_id {
    return 'russian_passport_series';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Серия паспорта', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 4,
        maxLength => 4,
        pattern   => '^[0-9]{4}$',
    };
}

1;
