package Field::swift;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PaymentInfo
  Type::swift
  );

use Utils;

sub _get_id {
    return 'swift';
}

sub _get_name {
    my ($self) = @_;
    return gettext('SWIFT', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'SWIFT-код банка, в котором открыт указанный счет. 8-11 букв латиницей',
        $self->{_language}
    );
}

1;
