package Field::taxation_type_belarus;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::PaymentInfo
  Type::radio
  );

use Utils;

sub _get_id {
    return 'taxation_type_belarus';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Тип налогообложения', $self->{_language});
}

sub get_dictionary {
    my ($self) = @_;
    return [
        {
            value       => 'УСН',
            description => 'ОСН - без НДС',
        },
        {
            value       => 'ОСН',
            description => 'ОСН - с НДС',
        }
    ];
}

1;
