package Field::ukraine_ph_warning;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::gfm_text);

use Utils qw(gettext);

sub _get_id {
    return 'ukraine_ph_warning';
}

sub _get_name {
    my ($self) = @_;

    return gettext(
'Регистрация в Рекламной сети для новых физических лиц из Украины приостановлена.',
        $self->{_language}
    );
}

sub get_group_name {
    my ($self) = @_;

    return gettext('Уведомление', $self->{_language});
}

sub is_valid {
    my ($self) = @_;

    # Всегда невалидно, чтобы нельзя было продолжить
    return {
        description =>
          gettext('В данный момент регистрация невозможна', $self->{_language}),
        is_valid => '',
    };
}

sub _get_json_schema {
    return {type => 'null',};
}

1;
