package Field::unp;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(
  Field::Groups::Company
  Type::input
  );

use Utils;

sub _get_id {
    return 'unp';
}

sub _get_name {
    my ($self) = @_;
    return gettext('УНП', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Узнать УНП можно на сайте или в налоговой службе по месту жительства',
        $self->{_language}
    );
}

sub _get_json_schema {
    return {
        type      => 'string',
        pattern   => '^(?=.*[1-9])[0-9]{1,9}$',
        minLength => 1,
        maxLength => 9,
    };
}

1;
