package Field::video_channel_uri;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::input);

use Utils;

sub _get_id {
    my ($self) = @_;
    return 'video_channel_uri';
}

sub _get_name {
    my ($self) = @_;
    return gettext('Ссылка на ваш канал', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Ссылка на канал в формате https://www.youtube.com/channel/name',
        $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        maxLength => 100,
        pattern   => '^https://www.youtube.com/channel/.+$',
    };
}

sub get_group_name {
    my ($self) = @_;
    return gettext('Канал', $self->{_language});
}

1;
