package FormConstants;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Exporter);

use Hash::Util qw(lock_keys);

our @EXPORT_OK = qw(
  @API_TYPES_LIST

  $CYRILLIC_NAME_OR_EMPTY_STRING_RX
  $CYRILLIC_NAME_RX

  %PROJECTS
  $DEFAULT_PROJECT

  $SAVE_ATTACHMENT_MIN_FILE_SIZE
  $SAVE_ATTACHMENT_MAX_FILE_SIZE

  $BLOGER_NOTIFICATION_MAIL
  $CONTRACT_OFFER_ERROR_MAIL
  $PARTNER2_CRON_MAIL
  $PARTNERS_MAIL
  $PARTNERS_TEST_MAIL

  @ADFOX_PRESET_ADFOXSITES
  @ADFOX_PRESET_ALL
  @ADFOX_PRESET_ASSESSOR
  @ADFOX_PRESET_DEFAULT
  @ADFOX_PRESET_MOBILEMEDIATION
  @ADFOX_PRESET_PAIDPRODUCTS

  $STAGE

  $SENTRY_URL
  $SOLOMON_API_URL

  %TVM_MAP
  $TVM_BLACKBOX_ID
  $TVM_SELF_ID
  $TVM_SOLOMON_ID
  $TVM_URL
  );

our @API_TYPES_LIST = sort qw(
  adfox_account
  attachments
  bank_name
  bik
  bik_with_account_or_yandex_money
  boolean
  boolean_true
  campaign_creation
  date
  date_18
  email
  fias_address
  fias_ur_address
  gfm_text
  iban_or_account
  inn_ph
  inn_ur
  input
  mobile_app_creation
  multiselect
  oferta_agreement
  ogrnip
  phone
  pfr
  radio
  russian_passport_issuer_code
  select
  swift
  textarea
  yandex_money_details
  );

# Почему такое перечисление букв:
# 1) модификаторы:
#    а) qr/.../i при стрингификации преобразуется в '(?^ui:...)'
#    б) инлайн-модификаторы вида '(?^ui:...)' или '(?i)' не поддерживаются JavaScript'ом на фронте
# 2) буква "Ё":
#    символы "ё" и "Ё" в utf8 (в Unicode) лежат вне основных диапазонов а-я и А-Я
our $CYRILLIC_NAME_OR_EMPTY_STRING_RX = q<^(?:[А-ЯЁа-яё]+(?:['`" -][А-ЯЁа-яё]+)*)?$>;
our $CYRILLIC_NAME_RX                 = q<^[А-ЯЁа-яё]+(?:['`" -][А-ЯЁа-яё]+)*$>;

our %PROJECTS = (
    assessor         => 1,
    default          => 1,
    efir_blogger     => 1,
    games            => 1,
    mobile_mediation => 1,
    video_blogger    => 1,
);
lock_keys(%PROJECTS);
our $DEFAULT_PROJECT = 'default';

our $SAVE_ATTACHMENT_MIN_FILE_SIZE = 5 * 1024;
our $SAVE_ATTACHMENT_MAX_FILE_SIZE = 5 * 1024 * 1024;

our $BLOGER_NOTIFICATION_MAIL  = 'blogger@yandex-team.ru';
our $CONTRACT_OFFER_ERROR_MAIL = 'contract_offer_error@yandex-team.ru';
our $PARTNER2_CRON_MAIL        = 'partner2-cron@yandex-team.ru';
our $PARTNERS_MAIL             = 'partners@yandex-team.ru';
our $PARTNERS_TEST_MAIL        = 'partners-test-letters@yandex-team.ru';

our @ADFOX_PRESET_ASSESSOR        = qw(ASSESSOR);
our @ADFOX_PRESET_ADFOXSITES      = qw(ADFOXSITES);
our @ADFOX_PRESET_MOBILEMEDIATION = qw(MOBILEMEDIATION);
our @ADFOX_PRESET_PAIDPRODUCTS    = qw(PAIDPRODUCTS);

our @ADFOX_PRESET_DEFAULT = (@ADFOX_PRESET_ADFOXSITES, @ADFOX_PRESET_MOBILEMEDIATION);
our @ADFOX_PRESET_ALL = (@ADFOX_PRESET_ASSESSOR, @ADFOX_PRESET_DEFAULT, @ADFOX_PRESET_PAIDPRODUCTS);

our $STAGE = ($ENV{FORM_STAGE} // '');

my %SOLOMON_API_URL_BY_STAGE = (
    production => 'http://solomon.yandex.net/api/v2/push?project=PI&cluster=prod&service=form',
    test       => 'http://solomon.yandex.net/api/v2/push?project=PI&cluster=test&service=form',
    preprod    => 'http://solomon.yandex.net/api/v2/push?project=PI&cluster=preprod&service=form',
    dev        => 'http://solomon-test.yandex.net/api/v2/push?project=PI&cluster=dev&service=form',
);

# https://wiki.yandex-team.ru/solomon/api/push/
our $SOLOMON_API_URL = $SOLOMON_API_URL_BY_STAGE{$STAGE} // $SOLOMON_API_URL_BY_STAGE{'dev'};

my %SENTRY_URL_BY_STAGE = (
    production => 'https://sentry.t.yandex-team.ru/partnerinterface/production/',
    test       => 'https://sentry.t.yandex-team.ru/partnerinterface/test/',
    preprod    => 'https://sentry.t.yandex-team.ru/partnerinterface/preprod/',
    dev        => 'https://sentry-test.t.yandex-team.ru/partnerinterface/dev/',
);

our $SENTRY_URL = $SENTRY_URL_BY_STAGE{$STAGE} // $SENTRY_URL_BY_STAGE{'dev'};

our $TVM_BLACKBOX_ID = 222;
our $TVM_SELF_ID     = 2000661;
our $TVM_SOLOMON_ID  = 2010242;
our %TVM_MAP         = (
    $TVM_BLACKBOX_ID => 'blackbox',
    $TVM_SOLOMON_ID  => 'solomon',
);
our $TVM_URL = ($ENV{DEPLOY_TVM_TOOL_URL} // "http://localhost:18080") . "/tvm/tickets";

1;
