package Monitoring;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Carp;
use Cpanel::JSON::XS;
use Exporter;
use HTTP::Tiny;

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(
  send_to_solomon
  );
our @EXPORT = @EXPORT_OK;

use FormConstants qw(
  $SOLOMON_API_URL
  $STAGE
  $TVM_SOLOMON_ID
  );
use Yandex::TVM qw(get_x_ya_service_ticket);

# https://wiki.yandex-team.ru/solomon/api/push/
# https://wiki.yandex-team.ru/solomon/api/dataformat/json/
# https://clubs.at.yandex-team.ru/solomon/611
sub send_to_solomon {
    my (%opts) = @_;

    my $path  = $opts{path}  // croak 'Must specify path';
    my $value = $opts{value} // 1;

    # На dev в докере с параметром link не работает IPv6
    return if ($STAGE eq 'dev' || $STAGE eq 'test');

    my $content = {
        sensors => [
            {
                labels => {sensor => $path,},
                (
                    $opts{ts}
                    ? (ts => $opts{ts},)
                    : ()
                ),
                value => $value,
            },
        ],
    };
    my $response = HTTP::Tiny->new()->request(
        'POST',
        $SOLOMON_API_URL,
        {
            headers => {
                'Content-Type'        => 'application/json',
                'xxx'                 => '1',
                'X-Ya-Service-Ticket' => get_x_ya_service_ticket($TVM_SOLOMON_ID),
            },
            content => encode_json $content,
        }
    );

    my $status = ($response->{status} // '');
    if ($status ne '200') {
        print STDERR "Solomon status is $status\n";
        print STDERR $response->{content} if $response->{content};
    }
}

1;
