package Type::attachments;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Carp;
use Partner2;
use Utils;

sub _get_type {
    return 'attachments';
}

sub is_valid {
    my ($self, $value, $extra) = @_;

    croak "Must specify user_id" unless defined $extra->{user_id};

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    return {is_valid => 0} unless $result;

    return {
        is_valid => 0,
        description => gettext('Необходимо загрузить файл', $self->{_language})
      }
      if @{$value} == 0;
    return {
        is_valid => 0,
        description => gettext('Выбрано слишком много файлов', $self->{_language})
      }
      if @{$value} > 10;

    my %all = map {$_ => 1} @{list_attachments($extra->{user_id})};

    for my $key (@$value) {
        return {is_valid => 0} unless $all{$key};
    }

    return {is_valid => 1};
}

sub _get_json_schema {
    my ($self) = @_;

    return {
        type  => 'array',
        items => {type => 'string',},
    };
}

sub get_description {
    return <<EOM
Поле со списком ключей для файлов, приложенных заявке партнера (сканы документов)
Ключи предварительно получаются из ручки save_attachment

Значение поле — это массив id-шников загруженных файлов. В массиве должен быть хотя бы один элемент.
Максимальная длина массива — 10 элементов.
EOM
}

1;
