package Type::bank_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::input);

use Utils;

sub _get_name {
    my ($self) = @_;
    return gettext('Наименование банка', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext('Название банка получателя.', $self->{_language});
}

sub _get_json_schema {
    return {
        maxLength => 100,
        minLength => 1,
        type      => 'string',
    };
}

1;
