package Type::bik;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::input);

use Partner2;
use Utils;

sub _get_json_schema {
    return {
        type    => 'string',
        pattern => '^[0-9]{9}$',
    };
}

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    if ($result) {
        my $bank_data = get_bank_by_bik($value);

        $result = !!$bank_data->{found};
    }

    return {
        is_valid => $result,
        (
            $result
            ? ()
            : (description => gettext('Банк с указанным БИК не найден', $self->{_language}))
        ),
    };
}

sub get_description {
    return <<EOM
Поле с типом bik. Это input в который пользователь может вводить какие-то символы.

Сначала ввод пользователя нужно валидировать по json schema, но кроме этого нужно так же
проверять ввод с помощью ручки `bik` (эта ручка ходит во внешнюю систему для проверки, так
что самостоятельно реализовать эту проверку нельзя).
EOM
}

1;
