package Type::bik_with_account_or_yandex_money;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Partner2;
use Utils;
use Yandex::Balance;

sub _get_type {
    return 'bik_with_account_or_yandex_money';
}

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    if ($result && exists($value->{bik})) {
        my $bank_data = get_bank_by_bik($value->{bik});

        if ($bank_data->{found}) {

            if (check_account($value->{bik}, $value->{account})) {
                return {is_valid => 1,};
            } else {
                return {
                    is_valid => 0,
                    description =>
                      gettext('Номер счета не соответствует БИК', $self->{_language}),
                };
            }
        } else {
            return {
                is_valid => 0,
                description => gettext('Банк с указанным БИК не найден', $self->{_language}),
            };
        }
    } elsif ($result && exists($value->{yandex_money})) {
        my $deps     = $extra->{dependencies};
        my $is_valid = is_yamoney_account_identificated(
            account    => $value->{yandex_money},
            lastname   => $deps->{cyrillic_last_name},
            firstname  => $deps->{cyrillic_first_name},
            middlename => $deps->{cyrillic_patronymic_name},
            passport   => $deps->{russian_passport_series} . $deps->{russian_passport_number},
        );

        if ($is_valid) {
            return {is_valid => 1,};
        } else {
            return {
                is_valid    => 0,
                description => gettext(
'Счет в ЮMoney (Яндекс.Деньги) не прошел идентификацию, либо данные, указанные при регистрации, не совпадают с данными идентифицированного кошелька.',
                    $self->{_language}
                ),
            };
        }
    } else {
        return {is_valid => 0,};
    }

}

sub _get_json_schema {
    my ($self) = @_;

    return {
        oneOf => [
            {
                type       => 'object',
                properties => {yandex_money => {type => 'string',},},
                required   => ['yandex_money'],
            },
            {
                type       => 'object',
                properties => {
                    bik => {
                        type    => 'string',
                        pattern => '^[0-9]{9}$',
                    },
                    account => {
                        type    => 'string',
                        pattern => '^[0-9]{20}$',
                    },
                },
                required => ['bik', 'account'],
            },
        ],
    };
}

sub get_dependencies {
    my ($self) = @_;

    return [
        "cyrillic_last_name",      "cyrillic_first_name", "cyrillic_patronymic_name",
        "russian_passport_series", "russian_passport_number",
    ];
}

sub get_description {
    return <<EOM
Тип для платежных реквизитов.

В качестве значения поля с этим типом backend ожидает получить объект

либо:

    {
        "bik" : "044525225",
        "account": "30101810400000000225"
    }

либо:

    {
        "yandex_money" : "4100143322850"
    }

Кроме валидации по json-схеме еще проверятеся значение bik. Мы можем
принимать только те БИКи, про которые знает баланс. Для проверки
БИК нужно использовать ручку `/form/api/0/bik`.
EOM
}

1;
