package Type::boolean_true;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Carp;
use JSON::XS;

use Utils;

sub _get_type {
    return 'boolean_true';
}

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    return {
        is_valid => !!$result,
        ($result ? () : (description => $self->_error_description())),
    };
}

sub _get_json_schema {
    return {
        type => 'boolean',
        enum => [JSON::XS::true],
    };
}

sub _error_description {
    my ($self) = @_;

    return gettext('Вам необходимо согласиться с условиями', $self->{_language});
}

sub get_description {
    return <<EOM
Поле с типом boolean_true — это чекбокс. Это такой специальный чекбокс который обязательо
должен быть выставлен в true.

В качестве значения backend ожидает получить true.
EOM
}

1;
