package Type::cyrillic_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::input);

use FormConstants qw($CYRILLIC_NAME_RX);
use Utils;

sub get_hint {
    my ($self) = @_;
    return gettext('Как в паспорте.', $self->{_language});
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 1,
        pattern   => $CYRILLIC_NAME_RX,
    };
}

sub normalize {
    my ($self, $value) = @_;

    return normalize_cyrillic_names($value);
}

1;
