package Type::cyrillic_patronymic_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::cyrillic_name);

use FormConstants qw($CYRILLIC_NAME_OR_EMPTY_STRING_RX);
use Utils;

sub _get_json_schema {
    return {
        type    => 'string',
        pattern => $CYRILLIC_NAME_OR_EMPTY_STRING_RX,
    };
}

sub _get_name {
    my ($self) = @_;
    return gettext('Отчество', $self->{_language});
}

sub get_value {
    return '';
}

1;
