package Type::date;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Carp;
use Utils::Moment;

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    return {is_valid => 0,} unless $result;

    my $now = Utils::Moment->now();
    my $is_valid_date;
    eval {
        my $m = Utils::Moment->new(dt => $value . ' 00:00:00');

        my $date_is_in_the_past = $m->cmp($now) == -1;

        if ($m->get_year() >= 1900 && $date_is_in_the_past) {
            $is_valid_date = 1;
        }
    };

    return {is_valid => $is_valid_date,};
}

sub _get_type {
    return 'date';
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 10,
        maxLength => 10,
        pattern   => '^[0-9-]+$',
    };
}

sub get_description {
    return <<EOM
Поле с типом date — это контрол, в который нужно ввести дату.

Backend ожидает получить дату в виде строки в формате 'YYYY-MM-DD'.

Backend проверят что строка является валидной датой (например, строка '2016-45-98' валидацию не пройдет).
Backend принимает дату начиная с 1900-01-01 (эта дата еще валиданая, 1899-12-31 — не валиданая)
Backend считает максимальной валидной датой — дату вчера (т.е. если передать в backend сегодняшную дату — backend
на это ругнеться).
EOM
}

1;
