package Type::date_18;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::date);

use Carp;
use Utils::Moment;
use DateTime;
use Utils;

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    return {is_valid => 0,} unless $result;

    my $now_dt  = DateTime->now();
    my $m       = Utils::Moment->new(dt => $value . ' 00:00:00');
    my $date_dt = DateTime->from_epoch(epoch => $m->get_timestamp());

    my $duration = $now_dt->subtract_datetime($date_dt);

    return {
        is_valid => 0,
        description => gettext('Вам должно быть больше 18 лет', $self->{_language}),
      }
      if $duration->years() < 18;

    return {is_valid => 1,};
}

sub _get_type {
    return 'date_18';
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 10,
        maxLength => 10,
        pattern   => '^[0-9-]+$',
    };
}

sub get_value {
    my ($self, $user_data) = @_;

    return ($user_data->{dbfields}{'userinfo.birth_date.uid'} // '');
}

sub get_description {
    return <<EOM
Поле с типом date_18 — это контрол, в который нужно ввести дату.

Backend ожидает получить дату в виде строки в формате 'YYYY-MM-DD'.

Backend проверят что строка является валидной датой (например, строка '2016-45-98' валидацию не пройдет).
Backend принимает дату начиная с 1900-01-01 (эта дата еще валиданая, 1899-12-31 — не валиданая)

Дата является валидной только если с момента этой даты до сегодня прошло не меньше 18 лет.
EOM
}

1;
