package Type::email;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::input);

sub _get_json_schema {
    return {
        format  => 'email',
        pattern => '^[a-zA-Z0-9_\-\.]+\@[a-zA-Z0-9_\-]+(\.[a-zA-Z0-9_\-]+)+$',
        type    => 'string',
    };
}

sub get_value {
    my ($self, $user_data) = @_;

    return ($user_data->{'address-list'}[0]{'address'} // '');
}

1;
