package Type::fias_ur_address;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Partner2;

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    return {is_valid => 0,} unless !!$result;

    return {is_valid => (query_fias(guid => $value->{guid})->[0]{obj_level} // 0) == 7,};
}

sub _get_type {
    return 'fias_ur_address';
}

sub _get_json_schema {
    return {
        type       => 'object',
        properties => {
            guid => {
                type      => 'string',
                minLength => 36,
                maxLength => 36,
                pattern   => '^[0-9a-f-]{36}$',
            },
            house => {
                type      => 'string',
                minLength => 1,
            },
            structure => {
                type      => 'string',
                minLength => 1,
            },
            building => {
                type      => 'string',
                minLength => 1,
            },
            office => {
                type      => 'string',
                minLength => 1,
            },
            zip_code => {
                type      => 'string',
                maxLength => 20,
                pattern   => '^[a-zA-Z0-9 ]+$',
            },
        },
        required => ['guid', 'house', 'zip_code'],
    };
}

sub get_description {
    return <<EOM
Поле для адреса с валидацией по справочнику ФИАС
Отличается от fias_address тем, что поле apartment меняется на office и становится обязательным

region    - регион
area      - район
city      - город/населенный пункт
street    - улица
house     - дома
structure - корпус (опционально)
building  - строение (опционально)
office    - офис
zip_code  - индекс
EOM
}

1;
