package Type::inn_ph;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use List::Util qw(sum0);

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    my $is_valid = !!$result && _validate_inn_ph($value);

    return {is_valid => $is_valid,};
}

sub _validate_inn_ph {
    my ($value) = @_;

    return 0 unless int $value;

    my @d = split //, $value;
    my @c1 = (7, 2, 4, 10, 3, 5, 9, 4, 6, 8);
    my @c2 = (3, 7, 2, 4, 10, 3, 5, 9, 4, 6, 8);

    my $n11 = sum0(map {$d[$_] * $c1[$_]} (0 .. $#c1)) % 11 % 10;
    my $n12 = sum0(map {$d[$_] * $c2[$_]} (0 .. $#c2)) % 11 % 10;

    return $n11 == $d[10] && $n12 == $d[11];
}

sub _get_type {
    return 'inn_ph';
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 12,
        maxLength => 12,
        not       => {enum => ['0' x 12,],},
        pattern   => '^[0-9]{12}',
    };
}

sub get_description {
    return <<EOM
Поле для ввода ИНН физического лица

Валидация по json-схеме + проверка контрольных цифр

Пример корректного значения - 526317984689
EOM
}

1;
