package Type::inn_ur;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use List::Util qw(sum0);

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    my $is_valid = !!$result && _validate_inn_ur($value);

    return {is_valid => $is_valid,};
}

sub _validate_inn_ur {
    my ($value) = @_;

    return 0 unless int $value;

    my @d = split //, $value;
    my @c = (2, 4, 10, 3, 5, 9, 4, 6, 8);

    my $n10 = sum0(map {$d[$_] * $c[$_]} (0 .. $#c)) % 11 % 10;

    return $n10 == $d[9];
}

sub _get_type {
    return 'inn_ur';
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 10,
        maxLength => 10,
        not       => {enum => ['0' x 10,],},
        pattern   => '^[0-9]{10}',
    };
}

sub get_description {
    return <<EOM
Поле для ввода ИНН юридического лица

Валидация по json-схеме + проверка контрольных цифр

Пример корректного значения - 3664069397
EOM
}

1;
