package Type::mobile_app_creation;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Carp;

sub _get_type {
    return 'mobile_app_creation';
}

sub _get_json_schema {
    # Остновные проверки взяты из ПИ
    # В целом можно было бы объединить варианты для Android и iOS, но у них разные регэкспы для проверки bundle_id
    return {
        'items' => {
            'oneOf' => [
                {
                    'maxProperties' => 3,
                    'minProperties' => 3,
                    'properties'    => {
                        'store_id' => {    # PI: sub QBit::StringUtils::get_bundle_id
                            'minLength' => 3,
                            'pattern'   => qr/^[a-z][a-z0-9_]*(?:\.[a-z][a-z0-9_]*)+$/i,
                            'type'      => 'string',
                        },
                        'store_url' => {    # PI: sub QBit::StringUtils::get_domain
                            'minLength' => 4,
                            'pattern' =>
qr/^(?:https?:\/\/)?(?:www\.)?((?:[^:\s\/\.!@#$%^&*()\[\]\{\}\?\+;\'"`\\\\]+\.)*[^:\s\/\.!@#$%^&*()\[\]\{\}\?\+;\'"`\\\\]+)\.?(:\d{2,5})?($|\/|\?)/i,
                            'type' => 'string',
                        },
                        'type' => {         # PI: keys %{$PiConstants::APP_TYPES}    # 1 = Android, 2 = iOS
                            'enum' => [1],
                            'type' => 'integer',
                        },
                    },
                    'required' => [qw( store_id store_url type )],
                    'type'     => 'object',
                },
                {
                    'maxProperties' => 3,
                    'minProperties' => 3,
                    'properties'    => {
                        'store_id' => {     # PI: sub QBit::StringUtils::get_bundle_id
                            'minLength' => 1,
                            'pattern'   => qr/^[a-z0-9][a-z0-9-]*(?:\.[a-z0-9-]+)*$/i,
                            'type'      => 'string',
                        },
                        'store_url' => {    # PI: sub QBit::StringUtils::get_domain
                            'minLength' => 4,
                            'pattern' =>
qr/^(?:https?:\/\/)?(?:www\.)?((?:[^:\s\/\.!@#$%^&*()\[\]\{\}\?\+;\'"`\\\\]+\.)*[^:\s\/\.!@#$%^&*()\[\]\{\}\?\+;\'"`\\\\]+)\.?(:\d{2,5})?($|\/|\?)/i,
                            'type' => 'string',
                        },
                        'type' => {         # PI: keys %{$PiConstants::APP_TYPES}    # 1 = Android, 2 = iOS
                            'enum' => [2],
                            'type' => 'integer',
                        },
                    },
                    'required' => [qw( store_id store_url type )],
                    'type'     => 'object',
                },
            ],
        },
        'maxItems' => 3,         # На встрече договорились, что не больше трёх
        'minItems' => 1,
        'type'     => 'array',
    };
}

sub get_description {
    return <<EOM
Поле с типом mobile_app_creation — это поле для того чтобы отобрать форму для добавления мобильных приложений.

В качестве значения в ручку submit нужно отправлять массив объектов, содержащих поля store_id, store_url и type.
EOM
}

1;
