package Type::multiselect;

use strict;
use warnings FATAL => 'all';

use utf8;
use open qw(:std :utf8);

use base qw(Type::select);

sub _get_type {
    return 'multiselect';
}

sub _get_json_schema {
    my ($self) = @_;

    return {
        items => {
            enum => [map {$_->{value}} @{$self->get_dictionary()}],
            type => 'string',
        },
        minItems => 1,
        type     => 'array',
    };
}

sub get_description {
    return <<EOM
Поле с типом multiselect — это поля для выбора нескольких значений из списка.
EOM
}

1;
