package Type::ogrnip;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use List::Util qw(sum0);

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    my $is_valid = !!$result && _validate_ogrnip($value);

    return {is_valid => $is_valid,};
}

sub _validate_ogrnip {
    my ($value) = @_;

    #    return 0 unless int $value;

    # Алгоритм проверки контрольного числа
    # Выбрать 14-значное число ОГРНИП (с 1-й по 14-ю цифру).
    # Вычислить остаток от деления выбранного числа на 13.
    # Сравнить младший разряд полученного остатка от деления с 15-й цифрой ОГРНИП. Если они равны, то ОГРНИП верный.

    my $number  = substr($value, 0,  14);
    my $control = substr($value, 14, 1);

    my $mod             = $number % 13;
    my $mod_last_number = $mod % 10;

    return $mod_last_number == $control;
}

sub _get_type {
    return 'ogrnip';
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 15,
        maxLength => 15,
        not       => {enum => ['0' x 15,],},
        pattern   => '^[0-9]{15}$',
    };
}

sub get_description {
    return <<EOM
Поле для ввода ОГРНИП

Валидация по json-схеме + проверка контрольной цифры

Пример корректного значения - 304500116000157
EOM
}

1;
