package Type::organization_name;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::input);

use Carp;

use Utils;

sub _get_name {
    my ($self) = @_;
    return gettext('Название организации', $self->{_language});
}

sub get_hint {
    my ($self) = @_;
    return gettext(
'Как в свидетельстве о постановке на учет в налоговом органе. Правильный пример: Лучшая компания в мире. Неправильный пример: ООО "Лучшая компания в мире".',
        $self->{_language}
    );
}

sub _get_json_schema {
    my ($self) = @_;

    croak 'Need to inherit from Abc::* or implement "get_abc" method' if !$self->can('get_abc');

    return {
        type      => 'string',
        minLength => 1,
        # Не начинается с пробела               (?!\s)
        # Не заканчивается на пробел            (?!.*\s$)
        # Есть нормальные символы               (?=.*?[А-ЯЁа-яё])
        # Вся строка не заключена в кавычки     (?!".*"$)
        # Необязательнвя часть до кавычек       [-'\d\s\.,А-ЯЁа-яё]*
        # Необязательнча часть в кавычках       (?:"(?=.*?[А-ЯЁа-яё].*?")[-'\d\s\.,А-ЯЁа-яё]+")?
        # Необязательная часть после кавычек    [-'\d\s\.,А-ЯЁа-яё]*
        pattern =>
          sprintf(
q<^(?!\s)(?!.*\s$)(?=.*?[%1$s])(?!".*"$)[-'\d\s\.,%1$s]*(?:"(?=.*?[%1$s].*?")[-'\d\s\.,%1$s]+")?[-'\d\s\.,%1$s]*$>,
            $self->get_abc()),
           };
}

1;
