package Type::pfr;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Business::PFR;

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    my $bp = Business::PFR->new(value => $value,);

    my $is_valid = !!$result && $bp->is_valid();

    return {is_valid => $is_valid,};
}

sub _get_type {
    return 'pfr';
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 14,
        maxLength => 14,
        not       => {enum => ['000-000-000 00',],},
        pattern   => '^[0-9]{3}-[0-9]{3}-[0-9]{3} [0-9]{2}$',
    };
}

sub get_description {
    return <<EOM
Поле для СНИЛС - номера пенсионного страхования

Валидация по json-схеме + проверка контрольного числа

Пример валидного значения - "112-233-445 95" (без кавычек)
EOM
}

1;
