package Type::radio;

use strict;
use warnings FATAL => 'all';
use utf8;

use Carp;

use base qw(Type::Base);

sub _get_type {
    return 'radio';
}

sub _get_json_schema {
    my ($self) = @_;

    return {
        type => 'string',
        enum => [map $_->{value}, @{$self->get_dictionary}],
    };
}

sub get_description {
    return <<EOM
Поле с типом radio — это поля для выбора одного значения из списка.
EOM
}

sub get_dictionary {

    croak 'Need to implement';
}

1;
