package Type::russian_passport_issuer_code;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Carp;

sub _get_type {
    return 'russian_passport_issuer_code';
}

sub _get_json_schema {
    return {
        type      => 'string',
        minLength => 7,
        maxLength => 7,
        pattern   => '^[0-9]{3}-[0-9]{3}$',
    };
}

sub get_description {
    return <<EOM
Поле с типом russian_passport_issuer_code предназначено для ввода номера кода подраздения,
которое выдало паспорт.

Пример валидного значения: "772-050"

Валидация происходит только по json schema, никаких дополнительных проверок нет.
EOM
}

1;
