package Type::swift;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Business::SWIFT;
use Partner2;

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    my $is_valid = !!$result && Business::SWIFT->validateBIC($value);

    if ($is_valid) {
        my $bank_data = get_bank_by_swift($value);

        $is_valid = !!$bank_data->{found};
    }

    return {is_valid => $is_valid,};
}

sub _get_type {
    return 'swift';
}

sub _get_json_schema {
    return {
        maxLength => 11,
        minLength => 8,
        pattern   => '^[A-Z]{6,6}[A-Z2-9][A-Z1-9]([A-Z0-9]{3,3})?$',    # ISO 9362
        type      => 'string',
    };
}

sub get_description {
    return <<EOM
Поле с типом swift. Это input в который пользователь может вводить какие-то символы.

Сначала ввод пользователя нужно валидировать по json schema, но кроме этого нужно так же
проверять ввод с помощью ручки `swift` (либо самостоятельно реализовать алгоритм проверки
swift)

В будущем, возможно, это контрол будет расширен — пользователь вводит значнеие в input,
а кроме этого input для ввода еще есть disabled input в который записывается название
банка, который соотвествует валидному вводу пользователя.
EOM
}

1;
