package Type::yandex_money_details;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Type::Base);

use Carp;
use Business::SWIFT;
use Partner2;
use Utils;

sub is_valid {
    my ($self, $value, $extra) = @_;

    my $result = $self->SUPER::is_valid($value, $extra)->{is_valid};

    if ($result) {
        # account валидируем только по json схеме
        my $is_valid = is_yamoney_account_identificated(
            account    => $value->{yandex_money},
            lastname   => $value->{last_name},
            firstname  => $value->{first_name},
            middlename => $value->{patronymic_name},
            passport   => $value->{passport_number},
        );

        if ($is_valid) {
            return {is_valid => 1,};
        } else {
            return {
                is_valid    => 0,
                description => gettext(
'Счет в ЮMoney (Яндекс.Деньги) не прошел идентификацию, либо данные, указанные при регистрации, не совпадают с данными идентифицированного кошелька.',
                    $self->{_language}
                ),
            };
        }
    } else {
        return {is_valid => 0,};
    }
}

sub _get_type {
    return 'yandex_money_details';
}

sub _get_json_schema {
    my ($self) = @_;

    return {
        type       => 'object',
        properties => {
            yandex_money    => {type => 'string',},
            passport_number => {
                type      => 'string',
                minLength => 8,
                maxLength => 9,
                pattern   => '^([0-9]{9}|[А-Я]{2}[0-9]{6})$',
            },
            last_name => {
                type      => 'string',
                minLength => 1,
            },
            first_name => {
                type      => 'string',
                minLength => 1,
            },
            patronymic_name => {
                type      => 'string',
                minLength => 1,
            },
        },
        required => ['yandex_money', 'passport_number', 'last_name', 'first_name', 'patronymic_name'],
    };
}

sub get_description {
    return <<EOM
С помощью этого контрола пользователь вводит номер Яндекс Денег + паспортные данные

Используется в анкете для физ.лиц Украины

В качестве значения поля с этим типом backend ожидает получить объект

    {
        "yandex_money" : "4100143322850",
        "passport_number" : "123456789",
        "last_name" : "Ткаченко",
        "first_name" : "Мариана",
        "patronymic_name" : "Ивановна"
    }

Валидация по json-схеме + поход в ручку Денег

EOM
}

1;
