package Utils::Moment;
# NOTE! скопировано отсюда https://metacpan.org/source/BESSARABV/Moment-1.3.0/lib/Moment.pm

$Moment::VERSION = '1.3.0';

use strict;
use warnings FATAL => 'all';

use Carp qw(croak);
use Time::Local qw(timegm_nocheck);
use Scalar::Util qw(blessed);

sub new {
    my ($class, @params) = @_;

    if (@params == 0) {
        croak "Incorrect usage. new() must get some params: dt, timestamp or year/month/day/hour/minute/secod. Stopped";
    }

    if (@params % 2 != 0) {
        croak 'Incorrect usage. new() must get hash like: `new( timestamp => 0 )`. Stopped';
    }

    my %params = @params;

    if (blessed($class)) {
        croak "Incorrect usage. You can't run new() on a variable. Stopped";
    }

    my $self = {};
    bless $self, $class;

    my $input_year   = delete $params{year};
    my $input_month  = delete $params{month};
    my $input_day    = delete $params{day};
    my $input_hour   = delete $params{hour};
    my $input_minute = delete $params{minute};
    my $input_second = delete $params{second};

    my $input_iso_string = delete $params{iso_string};

    my $input_dt = delete $params{dt};

    my $input_timestamp = delete $params{timestamp};

    if (%params) {
        croak "Incorrect usage. new() got unknown params: '" . join("', '", (sort keys %params)) . "'. Stopped";
    }

    my $way = 0;

    if (defined($input_iso_string)) {
        $way++;

        if ($input_iso_string =~ /\A([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})Z\z/) {
            $self->{_year}   = $1;
            $self->{_month}  = $2 + 0;
            $self->{_day}    = $3 + 0;
            $self->{_hour}   = $4 + 0;
            $self->{_minute} = $5 + 0;
            $self->{_second} = $6 + 0;
        } else {
            my $safe_iso_string = 'undef';
            $safe_iso_string = "'$input_iso_string'" if defined $input_iso_string;
            croak "Incorrect usage. dt $safe_iso_string is not in expected format 'YYYY-MM-DDThh:mm:ssZ'. Stopped";
        }

        $self->_get_range_value_or_die('year',  $self->{_year},  1800, 2199);
        $self->_get_range_value_or_die('month', $self->{_month}, 1,    12);
        $self->_get_range_value_or_die('day', $self->{_day}, 1,
            $self->_get_last_day_in_year_month($self->{_year}, $self->{_month}));
        $self->_get_range_value_or_die('hour',   $self->{_hour},   0, 23);
        $self->_get_range_value_or_die('minute', $self->{_minute}, 0, 59);
        $self->_get_range_value_or_die('second', $self->{_second}, 0, 59);

        $self->{_timestamp} =
          timegm_nocheck($self->{_second}, $self->{_minute}, $self->{_hour}, $self->{_day}, $self->{_month} - 1,
            $self->{_year},);

        $self->{_dt} = sprintf("%04d-%02d-%02d %02d:%02d:%02d",
            $self->{_year}, $self->{_month}, $self->{_day}, $self->{_hour}, $self->{_minute}, $self->{_second},);

    }

    if (defined($input_timestamp)) {
        $way++;

        $self->{_timestamp} =
          $self->_get_range_value_or_die('timestamp', $input_timestamp, -5_364_662_400, 7_258_118_399);

        my ($second, $minute, $hour, $day, $month, $year, $wday, $yday, $isdst) = gmtime($self->{_timestamp});

        $self->{_year}   = $year + 1900;
        $self->{_month}  = $month + 1;
        $self->{_day}    = $day;
        $self->{_hour}   = $hour;
        $self->{_minute} = $minute;
        $self->{_second} = $second;

        $self->{_dt} = sprintf("%04d-%02d-%02d %02d:%02d:%02d",
            $self->{_year}, $self->{_month}, $self->{_day}, $self->{_hour}, $self->{_minute}, $self->{_second},);

    }

    if (   defined($input_year)
        or defined($input_month)
        or defined($input_day)
        or defined($input_hour)
        or defined($input_minute)
        or defined($input_second))
    {

        $way++;

        if (    defined($input_year)
            and defined($input_month)
            and defined($input_day)
            and defined($input_hour)
            and defined($input_minute)
            and defined($input_second))
        {
            # ok
        } else {
            croak "Must specify all params: year, month, day, hour, minute, second. Stopped";
        }

        $self->{_year}  = $self->_get_range_value_or_die('year',  $input_year,  1800, 2199);
        $self->{_month} = $self->_get_range_value_or_die('month', $input_month, 1,    12);
        $self->{_day} =
          $self->_get_range_value_or_die('day', $input_day, 1,
            $self->_get_last_day_in_year_month($self->{_year}, $self->{_month}));
        $self->{_hour}   = $self->_get_range_value_or_die('hour',   $input_hour,   0, 23);
        $self->{_minute} = $self->_get_range_value_or_die('minute', $input_minute, 0, 59);
        $self->{_second} = $self->_get_range_value_or_die('second', $input_second, 0, 59);

        $self->{_timestamp} =
          timegm_nocheck($self->{_second}, $self->{_minute}, $self->{_hour}, $self->{_day}, $self->{_month} - 1,
            $self->{_year},);

        $self->{_dt} = sprintf("%04d-%02d-%02d %02d:%02d:%02d",
            $self->{_year}, $self->{_month}, $self->{_day}, $self->{_hour}, $self->{_minute}, $self->{_second},);

    }

    if (defined($input_dt)) {
        $way++;

        if ($input_dt =~ /\A([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})\z/) {
            $self->{_year}   = $1;
            $self->{_month}  = $2 + 0;
            $self->{_day}    = $3 + 0;
            $self->{_hour}   = $4 + 0;
            $self->{_minute} = $5 + 0;
            $self->{_second} = $6 + 0;
        } else {
            my $safe_dt = 'undef';
            $safe_dt = "'$input_dt'" if defined $input_dt;
            croak "Incorrect usage. dt $safe_dt is not in expected format 'YYYY-MM-DD hh:mm:ss'. Stopped";
        }

        $self->_get_range_value_or_die('year',  $self->{_year},  1800, 2199);
        $self->_get_range_value_or_die('month', $self->{_month}, 1,    12);
        $self->_get_range_value_or_die('day', $self->{_day}, 1,
            $self->_get_last_day_in_year_month($self->{_year}, $self->{_month}));
        $self->_get_range_value_or_die('hour',   $self->{_hour},   0, 23);
        $self->_get_range_value_or_die('minute', $self->{_minute}, 0, 59);
        $self->_get_range_value_or_die('second', $self->{_second}, 0, 59);

        $self->{_timestamp} =
          timegm_nocheck($self->{_second}, $self->{_minute}, $self->{_hour}, $self->{_day}, $self->{_month} - 1,
            $self->{_year},);

        $self->{_dt} = sprintf("%04d-%02d-%02d %02d:%02d:%02d",
            $self->{_year}, $self->{_month}, $self->{_day}, $self->{_hour}, $self->{_minute}, $self->{_second},);

    }

    if ($way == 1) {
        # this is the correct usage of new()
    } else {
        croak
"Incorrect usage. new() must get one thing from the list: dt, timestamp or year/month/day/hour/minute/second. Stopped";
    }

    $self->{_d} = substr($self->{_dt}, 0,  10);
    $self->{_t} = substr($self->{_dt}, 11, 8);

    my %wday2name = (
        0 => 'sunday',
        1 => 'monday',
        2 => 'tuesday',
        3 => 'wednesday',
        4 => 'thursday',
        5 => 'friday',
        6 => 'saturday',
    );

    $self->{_weekday_number} = $self->_get_weekday_number($self->{_timestamp});
    $self->{_weekday_name}   = $wday2name{$self->{_weekday_number}};

    return $self;
}

sub now {
    my ($class, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. now() shouldn\'t get any params. Stopped';
    }

    if (blessed($class)) {
        croak "Incorrect usage. You can't run now() on a variable. Stopped";
    }

    my $self = Utils::Moment->new(timestamp => time(),);

    return $self;
}

sub get_timestamp {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_timestamp() shouldn\'t get any params. Stopped';
    }

    return $self->{_timestamp};
}

sub get_dt {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_dt() shouldn\'t get any params. Stopped';
    }

    return $self->{_dt};
}

sub get_iso_string {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_iso_string() shouldn\'t get any params. Stopped';
    }

    my $iso_string = $self->{_dt};
    $iso_string =~ s/ /T/;
    $iso_string .= 'Z';

    return $iso_string;
}

sub get_d {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_d() shouldn\'t get any params. Stopped';
    }

    return $self->{_d};
}

sub get_t {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_t() shouldn\'t get any params. Stopped';
    }

    return $self->{_t};
}

sub get_year {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_year() shouldn\'t get any params. Stopped';
    }

    return $self->{_year};
}

sub get_month {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_month() shouldn\'t get any params. Stopped';
    }

    return $self->{_month};
}

sub get_day {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_day() shouldn\'t get any params. Stopped';
    }

    return $self->{_day};
}

sub get_hour {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_hour() shouldn\'t get any params. Stopped';
    }

    return $self->{_hour};
}

sub get_minute {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_minute() shouldn\'t get any params. Stopped';
    }

    return $self->{_minute};
}

sub get_second {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_second() shouldn\'t get any params. Stopped';
    }

    return $self->{_second};
}

sub get_weekday_name {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_weekday_name() shouldn\'t get any params. Stopped';
    }

    return $self->{_weekday_name};
}

sub get_weekday_number {
    my ($self, @params) = @_;

    if (@params == 0) {
        croak "Incorrect usage. get_weekday_number() must get param: first_day. Stopped";
    }

    if (@params % 2 != 0) {
        croak
"Incorrect usage. get_weekday_number() must get hash like: `get_weekday_number( first_day => 'monday' )`. Stopped";
    }

    my %params = @params;

    my $first_day = delete $params{first_day};

    if (%params) {
        croak "Incorrect usage. get_weekday_number() got unknown params: '"
          . join("', '", (sort keys %params))
          . "'. Stopped";
    }

    my %name2number = (
        sunday    => 1,
        monday    => 0,
        tuesday   => -1,
        wednesday => -2,
        thursday  => -3,
        friday    => -4,
        saturday  => -5,
    );

    if (not exists $name2number{$first_day}) {
        croak "Incorrect usage. get_weekday_number() got unknown value '$first_day' for first_day. Stopped";
    }

    my $number = $self->{_weekday_number} + $name2number{$first_day};

    if ($number < 1) {
        $number += 7;
    }

    return $number;
}

sub is_monday {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. is_monday() shouldn\'t get any params. Stopped';
    }

    return $self->get_weekday_name() eq 'monday';
}

sub is_tuesday {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. is_tuesday() shouldn\'t get any params. Stopped';
    }

    return $self->get_weekday_name() eq 'tuesday';
}

sub is_wednesday {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. is_wednesday() shouldn\'t get any params. Stopped';
    }

    return $self->get_weekday_name() eq 'wednesday';
}

sub is_thursday {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. is_thursday() shouldn\'t get any params. Stopped';
    }

    return $self->get_weekday_name() eq 'thursday';
}

sub is_friday {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. is_friday() shouldn\'t get any params. Stopped';
    }

    return $self->get_weekday_name() eq 'friday';
}

sub is_saturday {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. is_saturday() shouldn\'t get any params. Stopped';
    }

    return $self->get_weekday_name() eq 'saturday';
}

sub is_sunday {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. is_sunday() shouldn\'t get any params. Stopped';
    }

    return $self->get_weekday_name() eq 'sunday';
}

sub is_leap_year {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. is_leap_year() shouldn\'t get any params. Stopped';
    }

    return $self->_is_leap_year($self->get_year());
}

sub cmp {
    my ($self, @params) = @_;

    if (@params != 1) {
        croak "Incorrect usage. cmp() must get one parameter. Stopped";
    }

    my $moment_2 = $params[0];

    if (blessed($moment_2) and $moment_2->isa('Utils::Moment')) {
        return $self->get_timestamp() <=> $moment_2->get_timestamp();
    } else {
        croak "Incorrect usage. cmp() must get Moment object as a parameter. Stopped";
    }

}

sub plus {
    my ($self, @params) = @_;

    if (@params == 0) {
        croak 'Incorrect usage. plus() must get some params. Stopped';
    }

    if (@params % 2 != 0) {
        croak 'Incorrect usage. plus() must get hash like: `plus( hour => 1 )`. Stopped';
    }

    my %params = @params;

    my $day    = $self->_get_value_or_die('plus', 'day',    delete($params{day}));
    my $hour   = $self->_get_value_or_die('plus', 'hour',   delete($params{hour}));
    my $minute = $self->_get_value_or_die('plus', 'minute', delete($params{minute}));
    my $second = $self->_get_value_or_die('plus', 'second', delete($params{second}));

    if (%params) {
        croak "Incorrect usage. plus() got unknown params: '" . join("', '", (sort keys %params)) . "'. Stopped";
    }

    my $new_timestamp = $self->get_timestamp() + $day * 86400 + $hour * 3600 + $minute * 60 + $second;

    my $new_moment = ref($self)->new(timestamp => $new_timestamp);

    return $new_moment;
}

sub minus {
    my ($self, @params) = @_;

    if (@params == 0) {
        croak 'Incorrect usage. minus() must get some params. Stopped';
    }

    if (@params % 2 != 0) {
        croak 'Incorrect usage. minus() must get hash like: `minus( hour => 1 )`. Stopped';
    }

    my %params = @params;

    my $day    = $self->_get_value_or_die('minus', 'day',    delete($params{day}));
    my $hour   = $self->_get_value_or_die('minus', 'hour',   delete($params{hour}));
    my $minute = $self->_get_value_or_die('minus', 'minute', delete($params{minute}));
    my $second = $self->_get_value_or_die('minus', 'second', delete($params{second}));

    if (%params) {
        croak "Incorrect usage. minus() got unknown params: '" . join("', '", (sort keys %params)) . "'. Stopped";
    }

    my $new_timestamp = $self->get_timestamp() - $day * 86400 - $hour * 3600 - $minute * 60 - $second;

    my $new_moment = ref($self)->new(timestamp => $new_timestamp);

    return $new_moment;
}

sub get_month_start {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_month_start() shouldn\'t get any params. Stopped';
    }

    my $start = ref($self)->new(
        year   => $self->get_year(),
        month  => $self->get_month(),
        day    => 1,
        hour   => 0,
        minute => 0,
        second => 0,
    );

    return $start;
}

sub get_month_end {
    my ($self, @params) = @_;

    if (@params) {
        croak 'Incorrect usage. get_month_end() shouldn\'t get any params. Stopped';
    }

    my $end = ref($self)->new(
        year   => $self->get_year(),
        month  => $self->get_month(),
        day    => $self->_get_last_day_in_year_month($self->get_year(), $self->get_month()),
        hour   => 23,
        minute => 59,
        second => 59,
    );

    return $end;
}

sub _get_weekday_number {
    my ($self, $timestamp) = @_;

    my ($second, $minute, $hour, $day, $month, $year, $wday, $yday, $isdst) = gmtime($timestamp);

    return $wday;
}

# https://metacpan.org/pod/Data::Printer#MAKING-YOUR-CLASSES-DDP-AWARE-WITHOUT-ADDING-ANY-DEPS
sub _data_printer {
    my ($self, $properties) = @_;

    require Term::ANSIColor;

    return Term::ANSIColor::colored($self->get_iso_string(), 'yellow');
}

sub _is_int {
    my ($self, $maybe_int) = @_;

    return $maybe_int =~ /\A0\z|\A-?[1-9][0-9]*\z/;
}

sub _get_value_or_die {
    my ($self, $method_name, $key, $input_value) = @_;

    my $value = $input_value;

    $value = 0 if not defined $value;

    if (not $self->_is_int($value)) {
        croak "Incorrect usage\. $method_name\(\) must get integer for '$key'. Stopped";
    }

    return $value;
}

sub _get_range_value_or_die {
    my ($self, $key, $input_value, $min, $max) = @_;

    my $safe_value = 'undef';
    $safe_value = "'$input_value'" if defined $input_value;

    if (not $self->_is_int($input_value)) {
        croak "Incorrect usage\. The $key $safe_value is not an integer number. Stopped";
    }

    if (($input_value < $min) or ($input_value > $max)) {
        croak "Incorrect usage. The $key $safe_value is not in range [$min, $max]. Stopped";
    }

    return $input_value;
}

sub _is_leap_year {
    my ($self, $year) = @_;

    return '' if $year % 4;
    return 1  if $year % 100;
    return '' if $year % 400;
    return 1;
}

sub _get_last_day_in_year_month {
    my ($self, $year, $month) = @_;

    my %days_in_month = (
        1 => 31,
        # no february
        3  => 31,
        4  => 30,
        5  => 31,
        6  => 30,
        7  => 31,
        8  => 31,
        9  => 30,
        10 => 31,
        11 => 30,
        12 => 31,
    );

    my $last_day;

    if ($month == 2) {
        if ($self->_is_leap_year($year)) {
            $last_day = 29;
        } else {
            $last_day = 28;
        }
    } else {
        $last_day = $days_in_month{$month};
    }

    return $last_day;
}

1;

__END__
