package Yandex::Balance;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Carp;
use Exporter;

use Partner2;

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(
  check_account
  );
our @EXPORT = @EXPORT_OK;

=head2 check_account

    my $bik = "044525225";
    my $account = "40702810638050013199";

    my $bool = check_account($bik, $account);

Возвращает true значение если указанный номер счета соответствует БИКу банка.

=cut

sub check_account {
    my ($bik, $account) = @_;

    # Единые казначейские счета (ЕКС) начиняются с нуля (#PI-23166)
    return ($account =~ /^0\d{19}$/)
      ? 1
      : check_bik_and_account($bik, $account);
}

1;
