package Yandex::TVM;

use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Carp;
use CHI;
use Exporter;
use HTTP::Tiny;
use JSON::PP;
use URI;

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(
  get_x_ya_service_ticket
  );
our @EXPORT = @EXPORT_OK;

use FormConstants qw(
  %TVM_MAP
  $TVM_SELF_ID
  $TVM_URL
  );

my $CACHE = CHI->new(
    driver => 'Memory',
    global => 1,
);

sub get_x_ya_service_ticket {
    my ($dst_id) = @_;

    croak "Can't find out TVM destination ID" unless $dst_id;

    my $service = $TVM_MAP{$dst_id};
    croak "Unknown TVM service '$dst_id'" unless $service;

    return 'dev' if ($ENV{FORM_STAGE} // 'dev') eq 'dev';

    my $key = "x_ya_service_ticket_$dst_id";

    my $value = $CACHE->get($key);

    if (!defined $value) {

        eval {
            my $uri = URI->new($TVM_URL);
            $uri->query_form(
                dsts => $dst_id,
                src  => $TVM_SELF_ID,
            );

            my $response = HTTP::Tiny->new()
              ->request('GET', $uri->as_string(), {headers => {Authorization => $ENV{TVMTOOL_LOCAL_AUTHTOKEN},},},);

            my $content = $response->{content};
            my $answer  = decode_json $content;

            $value = $answer->{$service}{ticket};
            print STDERR "Incorrect TVM ticket for '$dst_id / $service': $content\n" unless $value;
        };

        croak "Can't find out 'X-Ya-Service-Ticket'" unless $value;

        $CACHE->set($key, $value, '1 hour');
    }

    return $value;

}

1;
