use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use File::Slurp qw(write_file);
use Test::More;
use Test::Differences;
use Test::Deep;
use Cpanel::JSON::XS;

use Branches;
use FormConstants qw($DEFAULT_PROJECT);
use Partner2;
use Submit;
use Utils;

use TestSubmit;

BEGIN {$ENV{DIFF_OUTPUT_UNICODE} = 1}

my $TEST_COMPLETE_DATA_FILE_NAME = '/app/t_external/branches.tmp';

sub main_in_test {

    my $self_update;
    my $list;
    my $continue;
    my %allow;

    if (@ARGV) {
        @allow{@ARGV} = (1) x @ARGV;
        $self_update  = delete $allow{self_update};
        $list         = delete $allow{list};
        $continue     = delete $allow{continue};
    }
    $self_update ||= $ENV{SELF_UPDATE};

    mock_check_pi_adfox_contracts();
    mock_check_bik_and_account();

    # Login: 'BeS.teST-024'
    my $user_id    = 607369863;
    my $user_login = 'BeS.teST-024';
    my @tests;
    my $rx = qr'.*/(([^/]+)/([^/]+))\.json\z';
    push @tests, map {[1, $_, (m/$rx/)[0 .. 2]]} glob '/app/t_data/branches/*/*';
    push @tests, map {
        [2, $_, map {"v2_$_"} (m/$rx/)[0 .. 2]]
    } glob '/app/t_data/branches_v2/*/*';

    @tests = grep {
        scalar grep {$allow{$_}}
          @$_
    } @tests if keys %allow;

    if ($list) {
        plan tests => 1;
        note explain \@tests;
        pass 'list';
        return;
    }

    plan tests => scalar @tests;

    my $test_complete_data;
    if ($continue && -f $TEST_COMPLETE_DATA_FILE_NAME) {
        $test_complete_data = get_data_from_json_file($TEST_COMPLETE_DATA_FILE_NAME) // {};
    } else {
        $test_complete_data = {};
    }

    foreach my $t (sort {$a->[2] cmp $b->[2]} @tests) {
        my ($version, $file_name, $name) = @$t;

        write_file($TEST_COMPLETE_DATA_FILE_NAME,
            Cpanel::JSON::XS->new->utf8->allow_nonref->pretty->canonical->encode($test_complete_data));

      SKIP: {
            skip $name, 1 if ($continue && $test_complete_data->{$name});
            $test_complete_data->{$name} = 1;

            my $data     = get_data_from_json_file($file_name);
            my $branches = Branches->new(
                version => $version,
                project => ($data->{submit}{project} // $DEFAULT_PROJECT),
            );

            my $update;
            subtest $name => sub {
                $update = is_submit_ok($name, $user_id, $user_login, $data, 1, $version,);
                done_testing();
            };
            write_file($file_name, Cpanel::JSON::XS->new->utf8->allow_nonref->pretty->canonical->encode($update))
              if $self_update;
        }
    }

    unlink $TEST_COMPLETE_DATA_FILE_NAME;
    done_testing();
}
main_in_test();
