#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ./lib
  );
use qbit;
use Application;

use Data::Dumper;
use Text::CSV_XS;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';

        *{'QBit::Application::check_rights'} = sub {1};
    }

    my $yndx_bessarabov_user_id = 0;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    # Берем записи из лога анкеты ПИ1
    # Если на одного юзера несколько записей, берем ПОСЛЕДНЮЮ по времени.
    # Там вроде были какие-то кейсы с перерегистрацией.
    # Считаю первую запись самой ОК
    my $pi1_form_logs = $app->partner1_db->_get_all(
        'SELECT l1.uid as user_id, l1.create_time as create_dt, l1.cooperation_type, l1.cooperation_form, l1.orgtype
         FROM partnerform_logs AS l1
         JOIN (
             SELECT uid, MIN(create_time) AS min_time
             FROM partnerform_logs group by uid
         ) AS l2
         ON l1.uid = l2.uid AND l1.create_time = l2.min_time;'
    );

    # Берем записи из лога анкеты ПИ2
    # Если на одного юзера несколько записей, берем ПОСЛЕДНЮЮ по времени.
    # В ПИ2 перерегистрации нет, но если анкета крашится, то в логе все равно остается запись
    # Считаю последнюю запись самой ОК
    # Также выкидываю ветку russia_ph_part2, т.к. это дозаполнение анкеты. Первичное заполнение - russia_ph_part1 - учтется
    my $pi2_form_logs = $app->partner_db->_get_all(
        'SELECT l1.user_id, l1.dt as create_dt, l1.branch_id
         FROM form_data AS l1
         JOIN (
             SELECT user_id, MAX(dt) AS max_time
             FROM form_data
             WHERE branch_id <> "russia_ph_part2"
             GROUP BY user_id
         ) AS l2
         ON l1.user_id = l2.user_id AND l1.dt = l2.max_time;'
    );

    # Для каждого юзера запоминаем про него данные из ПИ1 и из ПИ2
    my %users;
    $users{$_->{user_id}}{pi1_data} = $_ for @$pi1_form_logs;
    $users{$_->{user_id}}{pi2_data} = $_ for @$pi2_form_logs;

    # Достаем пейджи из ПИ1
    my $pi1_pages = $app->partner1_db->_get_all(
        'SELECT id, bs_page as page_id, createTime as create_dt, uid as owner_id, "pi1" as `from`
         FROM campaigns'
    );

    # Достаем пейджи из ПИ2
    my $pi2_pages = $app->partner_db->_get_all(
'SELECT id, create_date as create_dt, context_page_id as page_id, owner_id, "mobile" as page_type, "pi2" as `from` FROM mobile_app_settings
         union
         SELECT id, create_date as create_dt, page_id, owner_id, "web" as page_type, "pi2" as `from` FROM search_on_site_campaign
         union
         SELECT id, create_date as create_dt, page_id, owner_id, "web" as page_type, "pi2" as `from` FROM context_on_site_campaign'
    );

    # Распихиваем пейджи по владельцам
    for my $page (@$pi1_pages, @$pi2_pages) {
        if (defined $page->{page_id}) {
            $users{$page->{owner_id}}{pages}{$page->{page_id}} = $page;
        } else {
            $users{$page->{owner_id}}{pages}{"$page->{from}_$page->{id}"} = $page;
        }
    }

    # Тут в цикле идем по каждому владельцу и определяем
    # в какую когорту по месяцу регистрации/типу сотрудничества/типу площадки его записать.
    # Или выкинуть его из статистики.
    my %stats;
    for my $user_id (keys %users) {
        my $user = $users{$user_id};
        eval {
            {

                # Достаем форму сотрудничества и дату регистрации
                my ($person_type, $reg_dt) = get_person_type($user);

                # Скипаем если если мало данных или зареган раньше 2017-01-01
                next if $person_type eq 'none';
                next if compare_dates($reg_dt, '2017-01-01 00:00:00', iformat1 => 'db_time', iformat2 => 'db_time') < 0;

                # Достаем тип площадки и дату создания площадки
                my ($page_type, $create_dt) = get_first_page_info($user, $reg_dt);

                # Скипаем если если мало данных или создана раньше 2017-01-01
                next if $page_type eq 'none';
                next
                  if compare_dates($create_dt, '2017-01-01 00:00:00', iformat1 => 'db_time', iformat2 => 'db_time') < 0;

                my $delta = dates_delta_days($reg_dt, $create_dt, iformat => 'db_time');

                if ($delta < 0) {
                    # Если площадка создана раньше даты регистрации, кидаем варн
                    warn "User $user_id. Page create date $create_dt is earlier than reg date $reg_dt";
                } elsif ($delta > 7) {
                    # Если площадка создана больше чем через неделю после регистрации, то считаем, что чувак пришел с unknown площадкой
                    $page_type = 'unknown';
                }

                # Берем месяц, записываем в статистику
                my $month = trdate(db_time => month => $reg_dt);
                $stats{$month}{$person_type}{$page_type} += 1;
            }
            1;
        } or do {
            my $e = $@;
            warn $e;
            print Dumper($user);
        };
    }

    open(my $fh, '>', 'registration_stats.tsv') or die "Cannot open: $!";
    my $tsv =
      Text::CSV_XS->new({binary => 1, sep_char => "\t", eol => "\n", escape_char => undef, quote_char => undef});
    $tsv->print($fh, [qw(month person_type page_type count)]);
    for my $month (sort keys(%stats)) {
        for my $person_type (sort keys($stats{$month})) {
            for my $page_type (sort keys($stats{$month}{$person_type})) {
                $tsv->print($fh, [$month, $person_type, $page_type, $stats{$month}{$person_type}{$page_type}]);
            }
        }
    }
    close($fh) or die "Cannot close: $!";
    say 'END';
}

sub get_first_page_info {
    my ($user, $reg_dt) = @_;
    #Дано: инфа про юзера, дата регистрации, которую мы определили на предыдущем шаге

    #Берем все его пейджи, выкидываем созданные раньше даты регистрации, сортируем по дате создания
    my @user_pages =
      sort {compare_dates($a->{create_dt}, $b->{create_dt}, iformat1 => 'db_time', iformat2 => 'db_time')}
      grep {compare_dates($reg_dt,         $_->{create_dt}, iformat1 => 'db_time', iformat2 => 'db_time') <= 0}
      (values %{$user->{pages}});

    #Если пейджей нет, выбрасываем его из статистики
    return ('none', '') if (!@user_pages);

    #Если пейдж один, то берем его тип и дату создания
    if (@user_pages == 1) {
        return ($user_pages[0]{page_type} // 'unknown', $user_pages[0]{create_dt});
    }

    #Если у первых двух пейджей совпала дата создания
    if ($user_pages[0]{create_dt} eq $user_pages[1]{create_dt}) {
        #Если у обоих есть page_id, то сравниваем их
        if (defined($user_pages[0]{page_id}) && defined($user_pages[1]{page_id})) {
            if ($user_pages[0]{page_id} == $user_pages[1]{page_id}) {
                #page_id совпал - это один и тот же пейдж. скорее всего один хешик приехал из пи1, второй из пи2
                return ($user_pages[0]{page_type} // $user_pages[1]{page_type} // 'unknown', $user_pages[0]{create_dt});
            } else {
                #page_id не совпал - одновременно созданы два разных пейджа.
                #сравниваем типы: если они одинаковые, то берем его, иначе ставим unknown
                if ($user_pages[0]{page_type} eq $user_pages[1]{page_type}) {
                    return ($user_pages[0]{page_type}, $user_pages[0]{create_dt});
                } else {
                    return ('unknown', $user_pages[0]{create_dt});
                }
            }
        } elsif (defined($user_pages[0]{page_id})) {
            #page_id есть только у первого - берем его тип
            return ($user_pages[0]{page_type} // 'unknown', $user_pages[0]{create_dt});
        } elsif (defined($user_pages[1]{page_id})) {
            #page_id есть только у второго - берем его тип
            return ($user_pages[1]{page_type} // 'unknown', $user_pages[0]{create_dt});
        } else {
            #page_id нету у обоих - выбрасываем из статистики
            return ('none', '');
        }
    } else {
        #Если у первых двух пейджей дата создания отличается, то это разные пейджи
        #Берем его тип и дату создания
        return ($user_pages[0]{page_type} // 'unknown', $user_pages[0]{create_dt});
    }
}

sub get_person_type {
    my ($user) = @_;
    # Пытаемся определить чо за чувак: физик, юрик или ипшник

    # Если про чувака есть запись и в ПИ1 и в ПИ2 берем более ранюю
    # Иначе берем ту, которая есть
    if ($user->{pi1_data} && $user->{pi2_data}) {
        my $cmp = compare_dates(
            $user->{pi1_data}{create_dt}, $user->{pi2_data}{create_dt},
            iformat1 => 'db_time',
            iformat2 => 'db_time'
        );
        if ($cmp < 0) {
            return (get_pi1_person_type($user->{pi1_data}), $user->{pi1_data}{create_dt});
        } elsif ($cmp > 0) {
            return (get_pi2_person_type($user->{pi2_data}), $user->{pi2_data}{create_dt});
        } else {
            die 'User has duplicate form records' . Dumper($user);
        }
    } elsif ($user->{pi1_data}) {
        return (get_pi1_person_type($user->{pi1_data}), $user->{pi1_data}{create_dt});
    } elsif ($user->{pi2_data}) {
        return (get_pi2_person_type($user->{pi2_data}), $user->{pi2_data}{create_dt});
    } else {
        # У человека есть площадки, но нет записей в логах анкеты.
        # Встречал таких в ПИ1. Кажется, это очень старые кейсы. Поэтому выбрасываю
        return ('none', '');
    }
}

sub get_pi1_person_type {
    my ($user) = @_;

    # Тут вроде все просто. Определяем по данным из логов анкеты ПИ1
    if ($user->{cooperation_type} eq 'cop') {
        # Таких ребят вроде не должно быть в статистике с 2017-01-01
        return 'cop';
    } elsif ($user->{cooperation_form} eq 'ph') {
        return 'ph';
    } elsif ($user->{cooperation_form} eq 'ur' and $user->{orgtype} eq 'ip') {
        return 'ip';
    } elsif ($user->{cooperation_form} eq 'ur') {
        return 'ur';
    } else {
        die 'User has unknown person type: ' . Dumper($user);
    }
}

sub get_pi2_person_type {
    my ($user) = @_;

    # Тут вроде все просто. Определяем по ветке анкеты ПИ2
    if (grep {$user->{branch_id} eq $_} ('russia_ph', 'russia_ph_part1', 'ukraine_ph', 'ag_ph')) {
        return 'ph';
    } elsif (
        grep {
            $user->{branch_id} eq $_
        } ('russia_ip')
      )
    {
        return 'ip';
    } elsif (
        grep {
            $user->{branch_id} eq $_
        } ('russia_ur', 'tutby_ur', 'ag_ur')
      )
    {
        return 'ur';
    } else {
        die 'User has unknown person type: ' . Dumper($user);
    }
}

main();
