#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION
Скрипт удаляет записи из mail_notification
    отправленные и непериодические

=head1 USAGE
    perl ./bin/PI-15955_prune_table_mail_notification.pl --append_logs

=head1 OPTIONS

=cut

use lib::abs qw(
  ../lib
  );

use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        $app->partner_db->update_table(
            'mail_notification',
            sub {
                my ($new_table) = @_;

                my $multistate2leave =
                  $app->mail_notification->get_multistates_by_filter('not ((stopped or sent) and not periodicity)');

                my $query = $app->partner_db->query->select(
                    table  => $app->partner_db->mail_notification,
                    filter => ['multistate', 'IN', \$multistate2leave],
                );
                $new_table->add_multi([$query]);
            }
        );
    }
   );
