#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

  Скрипт проверяет наличие внутренних ролей у уволенных сотрудников
  Для работы должна быть выставлена переменная окружения STAFFTOKEN

=head1 USAGE

  PI-16302_check_internal_roles.pl --dry

=head1 OPTIONS

  ENV{STAFFTOKEN} - OAuth-токен для авторизации на стаффе

=cut

use lib::abs qw(
  ../lib
  );

use qbit;
use HTTP::Request::Common qw();
use List::Util qw(min);
use LWP::UserAgent;
use Utils::ScriptWrapper;

my $token;
my $size = 10;

sub args {
    my ($opts) = @_;

    return ('token:s' => \$opts->{'token'},);
}

run(
    sub {
        my ($app, $opts) = @_;

        $token = $opts->{token} // $ENV{STAFFTOKEN} // die 'OAuth token to staff is not specified';
        my @internal_role_ids = map {$_->{'is_internal'} ? $_->{'id'} : ()} @{$app->rbac->get_roles()};
        my $internal_users = $app->users->get_all(
            fields => [qw(id domain_login login roles)],
            filter => [AND => [{role_id => \@internal_role_ids}, [domain_login => "IS NOT" => undef],]],
        );
        print logstr 'Amount of internal users: ' . scalar @$internal_users;
        my %users;
        foreach my $user (@$internal_users) {
            my $login = $user->{domain_login};
            $users{$login} //= [];
            push @{$users{$login}}, $user;
        }
        my $dismissed_users = is_dismissed(keys %users);
        print logstr 'Amount of dismissed users: ' . scalar @$dismissed_users;
        foreach my $login (@$dismissed_users) {
            foreach my $user (@{$users{$login}}) {
                my $roles = [map {$_->{is_internal} ? $_->{id} : ()} @{$user->{roles}}];
                print logstr sprintf('Revoke internal roles for user %s (%s): %s',
                    $user->{id}, $user->{login}, join(', ', @$roles));
                $app->users->do_action($user->{id}, 'revoke_roles', roles_id => $roles) unless $opts->{dry_run};
            }
        }
    }
   );

sub is_dismissed {
    my (@list) = @_;

    my $ua = new LWP::UserAgent;
    my %headers = (Authorization => "OAuth $token",);
    my @result;
    for (my $i = 0; $i <= int(scalar(@list) / $size); $i++) {
        my $url = sprintf(
'https://staff-api.yandex-team.ru/v3/persons?login=%s&_fields=login,official.is_dismissed&official.is_dismissed=true',
            join(',', @list[$i * $size .. min($i * $size + $size - 1, $#list)]));
        my $request = HTTP::Request::Common::GET($url, %headers);
        my $response = $ua->request($request);
        die $response->status_line unless $response->is_success;
        my $content = $response->decoded_content();
        my $data    = from_json $content;
        push @result, map {$_->{official}{is_dismissed} ? $_->{login} : ()} @{$data->{result} // []};
    }

    return \@result;
}
