#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_META_CLUSTER='pythia'

YT_PROJECT_PATH='//home/partner/dict'

if [[ $1 && $1 == "block" ]]; then
    YT_TABLE_PATH="${YT_PROJECT_PATH}/block_tags"
    YT_FORMAT="<columns=[page_id;block_id;tags];enable_type_conversion=%true>schemaful_dsv"
elif [[ $1 && $1 == "page" ]]; then
    YT_TABLE_PATH="${YT_PROJECT_PATH}/page_tags"
    YT_FORMAT="<columns=[page_id;tags;service];enable_type_conversion=%true>schemaful_dsv"
else
    echo '1st parameter has to be block|page';
    exit
fi

if [[ $2 && -f $2 ]]; then
    FILE_PATH=$2
else
    echo '2nd parameter has to be file with tags';
    exit
fi

if [[ $3 && $3 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
else
    echo "~using TEST config";
fi

EXIT_STATUS=$(cat $2 | yt insert-rows $YT_TABLE_PATH --no-require-sync-replica --proxy $YT_META_CLUSTER --format $YT_FORMAT)
echo $EXIT_STATUS

exit
