#!/usr/bin/perl

use lib::abs qw(
  ../lib
  );

use qbit;
use Application;
use QBit::Validator;

my $app = Application->new();

$app->pre_run();

$app->set_cur_user({id => 198506264});

my @levels = map {$app->{$_}} @{$app->product_manager->get_statistics_accessors};

my $sql = "REPLACE `partner`.`statistics_reports_level_order` VALUES\n";
$sql .= join(",\n",
    map {"('" . $_->id . "', " . $_->sort_priority . ")"}
    sort {$a->sort_priority <=> $b->sort_priority} grep {$_->can('sort_priority')} @levels);

print "$sql;\n";
