#!/usr/bin/perl -w

use lib::abs qw(../lib);

use qbit;
use Application;
use Getopt::Long;

use Convertor;

use PiConstants qw($STATISTICAL_RTB_BLOCK_ID $M_RU_TEXT_USER_ID);

my $APP;
$APP = new Application();
$APP->pre_run();

$APP->set_app_locale('ru');

$APP->set_cur_user({id => 0, rights => {map {$_ => TRUE} keys(%{$APP->get_registered_rights()})}});

sub main {

    my ($p_page, $p_login, $p_an, $p_internal_an, $p_retreat, $p_reconvert, $blocks, $stat_block, $dont_fix_active);
    GetOptions(
        "only_login=s"    => \$p_login,
        "only_page_id=s"  => \$p_page,
        "do_internal_an"  => \$p_internal_an,
        "do_an"           => \$p_an,
        "blocks"          => \$blocks,
        "stat_block"      => \$stat_block,
        "retreat"         => \$p_retreat,
        "reconvert"       => \$p_reconvert,
        "dont_fix_active" => \$dont_fix_active,
    );

    unless ($p_an || $p_internal_an) {
        print(
            "\n
Обязательные параметры:\n
  --do_an  выбираем внешнюю РС\n
  --do_internal_an  работаем с внутренней РС\n
Опциональные\n
  --blocks конвертируем блоки\n
  --stat_block создаем статистический блок\n
  --dont_fix_active не меняем признак активности блока
  --reconvert удаляет блоки и связанные таблицы, заливает по новой
  --only_login=<login>\n
  --only_page_id=<page_id>\n
Обратное дейтсвие (через флаг active)\n
  --retreat\n
"
        );
    }

    print("Укажите --blocks или --stat_block\n"), exit unless $blocks || $stat_block;

    my $convertor = Convertor->new(app => $APP, dont_fix_active => $dont_fix_active, stdout => TRUE,);

    my $list_pages = [];
    my $time       = time;

    no warnings 'redefine';
    *Application::Model::Block::on_action_set_need_update = sub { };

    $p_login = $APP->partner_db->quote($p_login) if $p_login;
    if ($p_page) {
        $p_page = join(', ', map {$APP->partner_db->quote($_)} split(/\s*,\s*/, $p_page));
    }

    if ($p_an) {
        $convertor->set_log_file_name("direct_migration_for_an_$time.log");

        $list_pages = $APP->partner_db->_get_all('
            select page_id, login
                from
                    context_on_site_direct d
                    join context_on_site_campaign c on c.page_id = d.campaign_id
                    join users u on u.id = c.owner_id
                where d.campaign_id > 0
                    and u.id <> ' . $M_RU_TEXT_USER_ID . '
                    ' . ($p_retreat ? " and d.active = 0 "         : " and d.active = 1 ") . '
                    ' . ($p_login   ? " and login = $p_login "     : "") . '
                    ' . ($p_page    ? " and page_id in ($p_page) " : "") . '
                group by page_id
                order by u.login
        ');

        $convertor->w2log(sprintf("AN. Start. Total pages: %d", scalar(@$list_pages)));

        if ($p_retreat) {
            $convertor->retreat_pages($list_pages, "DirectAN", "RtbAN", "RtbStatblockAN", $blocks, $stat_block);
        } else {
            $convertor->convert_pages($list_pages, $p_reconvert, "DirectAN", "RtbConvertorAN", "RtbStatblockAN",
                $blocks, $stat_block);
        }
    }

    if ($p_internal_an) {
        $convertor->set_log_file_name("direct_migration_for_internal_an_$time.log");

        $list_pages = $APP->partner_db->_get_all('
            select campaign_id as page_id, login
                from
                    internal_context_on_site_direct d
                    join internal_context_on_site_campaign c on c.id = d.campaign_id
                    join users u on u.id = 54519301
                where d.campaign_id > 0
                    and u.id <> ' . $M_RU_TEXT_USER_ID . '
                    ' . ($p_retreat ? " and d.active = 0 " : " and d.active = 1 ") . '
                    ' . ($p_page ? " and d.campaign_id in ($p_page) " : "") . '
                group by page_id
        ');

        $convertor->w2log(sprintf("Internal AN. Start. Total pages: %d", scalar(@$list_pages)));

        if ($p_retreat) {
            $convertor->retreat_pages($list_pages, "DirectINT", "RtbINT", "RtbStatblockINT", $blocks, $stat_block);
        } else {
            $convertor->convert_pages($list_pages, $p_reconvert, "DirectINT", "RtbConvertorINT", "RtbStatblockINT",
                $blocks, $stat_block);
        }
    }

    $convertor->w2log("__END__");
}

main();
