#!/usr/bin/perl -w

use lib::abs qw(../lib);

use qbit;

open(my $fh, '<', $ARGV[0]) or die $!;

my $errors = {};
while (<$fh>) {
    if ($_ =~ /:\s((?:{[^}]+?})|(?:\d+?)),\sError:\s+(.+)/) {
        #Direct block: {"active":"1","id":"0","campaign_id":"47635"}, Error: Block with type "" not found
        my $page_id = $1;
        my $error   = $2;

        if ($error =~ /(.+?"set_need_update")/ || $error =~ /(.+?"set_check_statistics")/) {
            $error = $1;
        }

        $page_id = from_json($page_id)->{'campaign_id'} if $page_id =~ /^\{.+\}$/;

        $errors->{$error}{'count'}++;
        push(@{$errors->{$error}{'objects'}}, $page_id);
    }
}

my $n = 0;
foreach my $err (sort {$errors->{$b}{'count'} <=> $errors->{$a}{'count'}} keys(%$errors)) {
    print "$n. $err\n";

    my @page_ids   = ();
    my %uniq_pages = ();
    foreach (@{$errors->{$err}{'objects'}}) {
        unless ($uniq_pages{$_}) {
            #print "\t$_\n";
            push(@page_ids, $_);
        }

        $uniq_pages{$_} = TRUE;
    }

    print join(',', @page_ids);

    print "\n";

    $n++;
}
