#!/usr/bin/perl

use lib::abs qw(
  ../lib
  );
use feature 'say';
use qbit;

use Application;
use File::Temp qw(tempfile);

use PiConstants qw($STATISTICAL_RTB_BLOCK_ID $TECHNICAL_RTB_BLOCK_ID);

sub main {
    my $app = Application->new();
    $app->pre_run();
    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my ($fh, $file_name) = tempfile('PI_10264_resend_page_ids_XXXXXX', DIR => './');

    for my $model (qw(context_on_site_rtb internal_context_on_site_rtb)) {
        my %campaign_ids;
        $campaign_ids{$_->{campaign_id}} = 1
          for (
            @{
                $app->partner_db->$model->get_all(
                    fields => [qw(campaign_id)],
                    filter => [
                        OR => [
                            ['id'        => '=' => \$STATISTICAL_RTB_BLOCK_ID],
                            ['id'        => '=' => \$TECHNICAL_RTB_BLOCK_ID],
                            ['ex_direct' => '=' => \1],
                        ]
                    ],
                ),
            }
          );

        my $page_model = $app->$model->get_campaign_model_name();
        my $page_field = $app->$page_model->get_page_id_field_name();

        my %ids;
        $ids{$_->{$page_field}} = 1
          for (
            @{
                $app->partner_db->$page_model->get_all(
                    fields => [$page_field],
                    filter => _filter($page_model, $page_field, \%campaign_ids),
                ),
            }
          );

        print $fh "$_\n" for keys(%ids);
    }

    close($fh) or die "close: $!";

    say "END. resend_to_bk input file - $file_name";
}

main();

sub _filter {
    my ($page_model, $page_field, $campaign_ids) = @_;

    # +-----------+-----------------------+
    # | id        | login                 |
    # +-----------+-----------------------+
    # |  28166288 | m-ru-text             |
    # |  54519301 | adinside              |
    # | 120143188 | rambler-p             |
    # | 198392540 | avitortb2013          |
    # | 217912896 | gomailru-ads          |
    # | 238949518 | maximatelecom         |
    # | 265217053 | vk-rsya               |
    # | 269811143 | savvina-ale           |
    # | 301137679 | m-ru-2015             |
    # | 301147605 | wwwodnoklassniki-2015 |
    # | 356502796 | adv-vertis            |
    # | 426342434 | adsnativessp          |
    # +-----------+-----------------------+

    my @vips = (
        28166288,  54519301,  120143188, 198392540, 217912896, 238949518,
        265217053, 269811143, 301137679, 301147605, 356502796, 426342434
    );

    if ($page_model eq 'context_on_site_rtb') {
        return [AND => [[$page_field => 'IN' => \[keys %$campaign_ids]], ['owner_id' => 'NOT IN' => \\@vips],]];
    } else {
        return [AND => [[$page_field => 'IN' => \[keys %$campaign_ids]],]];
    }
}
