#!/usr/bin/perl

use qbit;

use Net::INET6Glue::INET_is_INET6;
use Config::IniFiles;
use Yandex::Tanker;

use lib::abs qw(../lib);

use PiSecrets;

#TODO: Сделать нормальный прием параметров -r и --ticket
# --upload загрузить измененные переводы в tanker
# --file (чтобы не выгружать файл из tanker а использовать уже частично измененный файл)
# --only_download только скачать из tanker
# perl ./bin/change_translations_into_tanker.pl -r 'контентн' -r 'fullscreen' --ticket=PI-18641 --upload

my $ticket = 'PI-18641';

my $startrek_base_url = "https://st.yandex-team.ru/";
my $startrek_url      = $startrek_base_url . $ticket;

my @regexp = ('контентн');
my $regexp_str = join('|', map {"(?:$_)"} @regexp);

main();

sub main {
    my $tanker = _get_tanker();

    my $response = from_json(Encode::decode_utf8($tanker->get_project_tjson(status => 'unapproved')));
    writefile(lib::abs::path('../translations'), to_json($response, pretty => TRUE));

    my $changes = change_translations($response);
    writefile(lib::abs::path('../new_translations'), to_json($changes, pretty => TRUE));

    if (grep {$_ eq '--upload'} @ARGV) {
        $tanker->_action_on_keyset(
            file   => lib::abs::path('../new_translations'),
            keyset => [keys(%{$changes->{'keysets'}})],
            format => 'tjson',
            action => 'merge',
        );
    }
}

sub _get_tanker {
    die('File ".tanker" does not exists.') unless -f '.tanker';

    my $config = Config::IniFiles->new(-file => '.tanker', -fallback => 'GENERAL', -nocase => TRUE)
      // die("File \".tanker\" is invalid:\n" . join("\n", @Config::IniFiles::errors));

    my $tanker_url;
    if (defined($config->val('GENERAL', 'server')) && $config->val('GENERAL', 'server') eq 'production') {
        $tanker_url = $Yandex::Tanker::PROD_URL;
    } elsif (defined($config->val('GENERAL', 'server')) && $config->val('GENERAL', 'server') eq 'test') {
        $tanker_url = $Yandex::Tanker::TEST_URL;
    } else {
        die('No "server" option in config file ".tanker". Expected it to be "production" or "test".');
    }

    my $tanker = Yandex::Tanker->new(
        {
            project => scalar($config->val('GENERAL', 'project-id')),
            url     => $tanker_url,
            token   => get_secret('tanker-pi2-token'),
        }
    );
}

sub change_translations {
    my ($response) = @_;

    my $key_count = 0;
    foreach my $keyset (sort keys(%{$response->{'keysets'}})) {
        foreach my $key (sort keys(%{$response->{'keysets'}{$keyset}{'keys'}})) {
            my $data = $response->{'keysets'}{$keyset}{'keys'}{$key};

            my $is_plural = $data->{'info'}{'is_plural'};

            #change only ru
            my $ru_translation = $data->{'translations'}{'ru'};

            my $text = $is_plural ? $ru_translation->{'form1'} : $ru_translation->{'form'};

            if ($text =~ m/$regexp_str/msi) {
                $key_count++;

                if ($is_plural) {
                    die('can not work with it: is_plural = true');
                } else {
                    my $new_text = get_new_translation($text);

                    $data->{'translations'}{'ru'}{'form'} = $new_text;
                }

                $data->{'info'}{'context'} = $startrek_url;

                foreach my $lang (grep {$_ ne 'ru'} keys(%{$data->{'translations'}})) {
                    $data->{'translations'}{$lang}{'status'} = 'requires_translation';
                }
            }
        }
    }

    print "ALL CHANGED KEYS: $key_count\n\n";

    return $response;
}

my %CHANGES = ();

sub get_new_translation {
    my ($text) = @_;

    foreach my $what (sort keys(%CHANGES)) {
        my $to = $CHANGES{$what};
        if ($text =~ /\Q$what\E/) {
            $text =~ s/\Q$what\E/$to/msg;
        }
    }

    return $text unless $text =~ m/$regexp_str/msi;

    print "TEXT: $text\n";

    print "WHAT TO CHANGE:\n";
    my $what_change = <STDIN>;
    utf8::decode($what_change);
    chomp($what_change);

    print "CHANGE TO:\n";
    my $to_change = <STDIN>;
    utf8::decode($to_change);
    chomp($to_change);

    $CHANGES{$what_change} = $to_change;

    my $changed = $text =~ s/\Q$what_change\E/$to_change/msg;

    print(($changed) ? "CHANGED\n\n" : "!!!NOT CHANGED!!!\n\n");

    return $text;
}
