#!/usr/bin/env perl

use strict;
use warnings;

use lib::abs qw(../lib);

use Data::Printer;

use qbit;
use Application;

{
    no warnings 'redefine';

    *QBit::Application::check_rights = sub {1};
}

my $app = Application->new();
$app->pre_run();
$app->set_cur_user({id => 0});

my $roles = $app->rbac->get_roles();
my %roles = map {$_->{id} => $_} @$roles;

foreach my $role (@$roles) {
    next unless exists $role->{'conflict_role_for_set'};
    print "Checking: '$role->{name}'($role->{id}) conflict_roles: ["
      . join(',', @{$role->{conflict_role_for_set}}) . "]\n";
    my $users = $app->users->get_all(fields => [qw(id login roles)], filter => {role_id => $role->{id}});
    foreach my $user (@$users) {
        my %user_roles = map {$_->{id} => TRUE} @{$user->{roles}};
        foreach my $conflict (@{$role->{'conflict_role_for_set'}}) {
            if ($user_roles{$conflict}) {
                warn
"\t$user->{login} has role '$role->{name}'($role->{id}) that conflicts with role '$roles{$conflict}{name}'($conflict)\n";

                if ($ARGV[0] && $ARGV[0] eq 'fix') {
                    printf("\tUser: %d, removed role %d\n", $user->{id}, $role->{id});

                    $app->partner_db->user_role->delete(
                        $app->partner_db->filter({user_id => $user->{id}, role_id => $role->{id}}));

                    last;
                }
            }
        }
    }
}

$app->post_run();
