#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт для просмотра и манипуляции файловым кешом CHI.

=head1 USAGE

perl bin/chi_file_cache.pl --list

perl bin/chi_file_cache.pl --purge

=head1 OPTIONS

  list  - Просмотр списка записей кеша
  purge - Удаление просроченных записей

=cut

use lib::abs qw(
  ../lib
  );

use qbit;
use Application;
use Pod::Usage;
use Getopt::Long qw();
use Time::HiRes qw(gettimeofday tv_interval);
use CHI;

main();

sub main {
    my $t0 = [gettimeofday()];

    my $app = Application->new();
    $app->pre_run();

    my ($list, $purge) = _get_args();

    my $cache = CHI->new(driver => 'File', root_dir => $app->get_option('chi_file_cache_dir'));

    my @keys_found = $cache->get_keys();

    if ($list) {
        print "Cache keys found: ", scalar(@keys_found), "\n";
        print $_, "\n" foreach @keys_found;
    }

    if ($purge) {
        print "Removing exprired cache entries.\n";
        $cache->purge();
    }

    $app->post_run();

    my $elapsed = sprintf '%.2f', tv_interval($t0, [gettimeofday()]);
    print "\nEND ($elapsed sec)\n";
}

sub _get_args {
    my $list  = 0;
    my $purge = 0;
    my $help  = 0;

    Getopt::Long::GetOptions(
        'list|l'   => \$list,
        'purge|d'  => \$purge,
        'help|?|h' => \$help,
    ) or pod2usage(1);

    pod2usage(-verbose => 2, -noperldoc => 1) if $help;

    return ($list, $purge);
}

__END__
