#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

  Нужно переключится на прод YT и МОЛ
  Пример вызова perl -I./lib bin/compare_mol_stat_with_acted_rows.pl --preload_accessors --ticket=PI-24658 --date_from=2021-06-01 --date_to=2021-06-30 --max_delta=0.001

=cut

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use File::Slurp qw( read_file  write_file );

use qbit;
use Utils::PublicID qw( split_block_public_id );
use Utils::ScriptWrapper;

sub args {
    my ($opts) = @_;

    return (
        'max_delta:s' => \$opts->{max_delta},
        'date_from:s' => \$opts->{date_from},
        'date_to:s'   => \$opts->{date_to},
    );
}

run(
    sub {
        my ($app, $opts) = @_;

        my $mol_data;
        {
            no warnings 'redefine';
            #Переопределяем сабу, т.к. по-умолчанию суммы округляеются до копеек
            local *Application::Model::BKStatistics::_get_float_from_mol_number = sub {
                my ($self, $number) = @_;

                $number //= 0;
                my $float = sprintf('%0.6f', $number / 1_000_000);
                $float += 0;
                return $float;
            };

            $mol_data = $app->bk_statistics->get_statistics2(
                "fields"           => ["partner_wo_nds"],
                "period"           => [$opts->{date_from}, $opts->{date_to}],
                "dimension_fields" => ["date|month"],
                "entity_fields"    => ["page_id"],
                "levels"           => []
            );
            $mol_data = {map {$_->{dimensions}{page_id} => $_->{measures}[0]{partner_wo_nds}} @{$mol_data->{points}}};
        }

        my $path       = "//home/balance/prod/log_tariff/public/expense/act_partner/acted_rows/$opts->{date_to}";
        my @columns    = qw (DT PageID BlockID RUBRewardWithoutNDS);
        my $data_jsonl = $app->api_yt->read_table_from_any_replica(
            replicas => $app->get_option('yt')->{'replicas'},
            path     => $path,
            headers  => {
                'X-YT-Output-Format' =>
                  sprintf('<columns=[%s];missing_value_mode=print_sentinel;format=pretty>schemaful_dsv',
                    join(';', @columns))
            },
            params => {
                input_row_limit => 100_000_000_000,
                timeout         => 20,
                attempts        => 3,
                delay           => 0,
            },
        );
        my $acted_rows;
        for my $row (split "\n", $data_jsonl) {
            my ($DT, $PAGEID, $BLOCKID, $SUMM) = split '\t', $row;
            if ($DT eq "$opts->{date_from}T00:00:00+0300") {
                $acted_rows->{$PAGEID} = ($acted_rows->{$PAGEID} // 0) + $SUMM;
            }
        }

        my $not_exists_in_mol = [grep {!$mol_data->{$_} && $acted_rows->{$_} > 0.01} keys %$acted_rows];
        print logstr "Pages from acted_rows without money in MOL", $not_exists_in_mol if @$not_exists_in_mol;

        my $delta = $opts->{max_delta} // 0.01;
        foreach my $page_id (grep {$mol_data->{$_}} keys %$acted_rows) {
            print logstr $page_id, "mol=$mol_data->{$page_id}", "act=$acted_rows->{$page_id}",
              "delta=" . sprintf("%.6f", $acted_rows->{$page_id} - $mol_data->{$page_id})
              if $mol_data->{$page_id} - $acted_rows->{$page_id} >= $delta
                  or $mol_data->{$page_id} - $acted_rows->{$page_id} <= -$delta;
        }

    }
   );
