#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;

use Getopt::Std;
use HTTP::Tiny;

# global vars
my $HELP = <<'END_MESSAGE';
Usage:
    program -i input.txt -o output.txt
Arguments:
    -i - input file name
    -o - output file name
both arguments are mandatory
END_MESSAGE

# subs

sub main {
    my %opts;
    getopt('hi:o:', \%opts);
    die $HELP if !%opts or $opts{'h'} or not($opts{'i'} and $opts{'o'});
    my ($input_file, $output_file) = ($opts{'i'}, $opts{'o'});

    open(my $input,  '<', $input_file)  or die "Cannot open input file: $input_file";
    open(my $output, '>', $output_file) or die "Cannot open output file: $output_file";

    convert_requests($input, $output);

    close($input);
    close($output);
}

{
    my $MOL_URL = 'http://bsfastexport-pre01e.yabs.yandex.ru/export/master-report-pi.cgi?only_queries=1';
    my $http_client = HTTP::Tiny->new('default_headers' => {'Content-Type' => 'application/json'});

    sub check_mol_request {
        my $mol_request_json = shift;

        my $response = $http_client->request('POST', $MOL_URL, {'content' => $mol_request_json});
        if ($response->{'status'} == 599) {
            my $exception_message = $response->{"content"};
            $exception_message =~ s/\s+/ /g;
            warn "ERROR: Occured exception during validating: $exception_message";
            return 0;
        }

        if ($response->{'status'} != 200) {
            warn "ERROR: Server returned error status during validating. Code:  " . $response->{'status'};
            return 0;
        }

        my (undef, $status_json) = split(/\{\s+/, $response->{'content'}, 2);

        unless ($status_json) {
            my $response_content = $response->{'content'};
            $response_content =~ s/\r?\n/ /g;
            warn "ERROR: Server returned invalid JSON: $response_content";
            return 0;
        }

        my $status;
        eval {$status = from_json("{$status_json")};
        if ($@) {
            my $response_content = $response->{'content'};
            $response_content =~ s/\r?\n/ /g;
            warn "ERROR: Server returned invalid JSON: $response_content";
            return 0;
        }

        unless ($status->{'error_text'} eq ''
            or $status->{'error_text'} eq
            'ModPerl::Util::exit: (120000) exit was called at /usr/share/perl5/Yabs/Stat/MasterReportPI.pm line 100')
        {
            my $error_text = $status->{'error_text'};
            $error_text =~ s/\r?\n/ /g;
            warn "ERROR: Vailidation fail due error: $error_text";
            return 0;
        }

        return 1;
    }
}

{
    my %_is_internal_user;

    sub is_internal_user {
        my ($app, $login) = @_;

        if (not exists($_is_internal_user{$login})) {
            my $user = $app->users->get_by_login($login, fields => [qw(roles)]);
            $_is_internal_user{$login} = grep {$_->{'is_internal'}} @{$user->{'roles'}};
        }

        return $_is_internal_user{$login};
    }
}

{
    my %_available_page_ids;

    # preprocess mol request because login != $current user
    sub pre_process_mol_request {
        my ($app, $login, $mol_request) = @_;

        return $mol_request if is_internal_user($app, $login);

        if (not exists($_available_page_ids{$login})) {
            my $user_id = $app->users->get_by_login($login, fields => [qw(id)])->{'id'};
            $_available_page_ids{$login} = [
                grep {defined $_} map {$_->{'page_id'}} @{
                    $app->all_pages->get_all(
                        fields => [qw(page_id)],
                        filter => {owner_id => $user_id}
                    )
                  }
            ];
        }

        die "Empty available page id list for user '$login'" unless @{$_available_page_ids{$login}};

        my $filters_pre = $mol_request->{'filters_pre'};

        if (exists($filters_pre->{'PageID'}) && exists($filters_pre->{'PageID'}{'eq'})) {
            my %available_page_ids = map {$_ => 1} @{$_available_page_ids{$login}};

            my @good_page_ids = grep {$available_page_ids{$_}} @{$filters_pre->{'PageID'}{'eq'}};

            $filters_pre->{PageID} = {eq => \@good_page_ids};
        } else {
            $filters_pre->{PageID} = {eq => $_available_page_ids{$login}};
        }
        return $mol_request;
    }
}

# Возвращает ссылку на массив из 0, 1 или 2 элементов
# Каждый элемент ссылка на хэш:
# {'mol_request' => json_string, 'is_validated' => 0 / 1};
# Если mol_request делать не нужно, то 'mol_request' == '{}'
# если ошибка при конвертации, то exception
sub convert_get_statistics2_arguments_to_mol_requests {
    my ($app, $login, $opts2_ref) = @_;

    my @result;
    # Параметр top_keys имеет смысл, только в том случае если указаны
    # какие-то поля для group_by, иначе игнорим.
    if (not($opts2_ref->{'top_keys'} and @{$opts2_ref->{'entity_fields'}})) {
        my $mol_request = $app->bk_statistics->_convert_get_statistics2_to_mol_request('get_statistics2' => $opts2_ref);
        return [{'mol_request' => '{}', 'is_validated' => 0}] if not defined $mol_request;

        pre_process_mol_request($app, $login, $mol_request);
        my $mol_request_json = to_json($mol_request);
        push @result,
          {
            'mol_request'  => $mol_request_json,
            'is_validated' => check_mol_request($mol_request_json),
          };

        return \@result;
    }
    # first mol request
    my $backup_order_by = $opts2_ref->{'order_by'};

    $opts2_ref->{'order_by'} = $opts2_ref->{'top_keys_order_by'};
    my $first_mol_request =
      $app->bk_statistics->_convert_get_statistics2_to_mol_request('get_statistics2' => $opts2_ref);

    return [{'mol_request' => '{}', 'is_validated' => 0}] if not defined $first_mol_request;

    delete($first_mol_request->{'group_by_date'});
    $first_mol_request->{'limits'} = {
        'limit'  => $opts2_ref->{'top_keys'},
        'offset' => 0,
    };

    pre_process_mol_request($app, $login, $first_mol_request);
    my $first_mol_request_json = to_json($first_mol_request);
    push @result,
      {
        'mol_request'  => $first_mol_request_json,
        'is_validated' => 0,
      };

    # second mol request
    $opts2_ref->{'order_by'} = $backup_order_by;
    my $second_mol_request =
      $app->bk_statistics->_convert_get_statistics2_to_mol_request('get_statistics2' => $opts2_ref);

    if (not defined $second_mol_request) {
        $result[0]{'is_validated'} = check_mol_request($first_mol_request_json);
        return \@result;
    }

    my $first_mol_answer;
    eval {$first_mol_answer = $app->bk_statistics->_safe_get_data(%$first_mol_request);};
    return \@result if $@;

    $result[0]{'is_validated'} = 1;

    my $additional_where = $app->bk_statistics->_get_additional_where_from_mol_answer($first_mol_answer);
    if (@$additional_where) {
        $second_mol_request->{'filters_pre'}->{'-and'} = $additional_where;
    }

    pre_process_mol_request($app, $login, $second_mol_request);
    my $second_mol_request_json = to_json($second_mol_request);
    push @result,
      {
        'mol_request'  => $second_mol_request_json,
        'is_validated' => check_mol_request($second_mol_request_json),
      };

    return \@result;
}

sub convert_requests {
    my ($input, $output) = @_;

    my $app = Application->new();
    $app->pre_run();

    my $yndx_bessarabov_user_id = 155209804;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    my $datetime;
    my $login;
    my $opts_json;            # get_statistics args in json
    my $opts2_json;           # get_statistics2 args in json
    my $mol_request_infos;    # result of convert_get_statistics2_arguments_to_mol_requests
    my $should_print;         # just flag

    print {$output} join("\t", qw(DateTime Login GetStatistics GetStatistics2 MolRequest IsMolRequestValidated)), "\n";

    while (<$input>) {
        $should_print = 0;
        chomp;
        my $message;
        ($datetime, $login, $message) = split(/\t/, $_, 3);
        warn "ERROR: Broken log: $_" and next if not defined $message;

        (undef, $opts_json) = split(/ with /, $message, 2);
        warn "ERROR: Broken 'message': $message" and next if not defined $opts_json;

        my %opts;
        eval {%opts = @{from_json($opts_json)}};
        warn "ERROR: Broken opts JSON: $opts_json" and next if $@;

        ($opts2_json, $mol_request_infos, $should_print) = ('null', undef, 1);

        my %opts2;
        eval {%opts2 = $app->bk_statistics->_convert_get_statistics_request_with_same_load(%opts)};
        warn "ERROR: Cannot convert opts to opts2 ($@): $opts_json" and next if $@;
        $opts2_json = to_json(\%opts2);

        eval {$mol_request_infos = convert_get_statistics2_arguments_to_mol_requests($app, $login, \%opts2);};
        $@ =~ s/\s+/ /g if $@;
        warn "ERROR: Cannot convert opts2 to mol_requests ($@): $opts2_json" if $@;
    } continue {
        $mol_request_infos //= [{'mol_request' => 'null', 'is_validated' => 0}];
        for my $e (@$mol_request_infos) {
            print {$output} join "\t",
              ($datetime, $login, $opts_json, $opts2_json, $e->{'mol_request'}, $e->{'is_validated'} . "\n");
            warn "ERROR: Cannot validate mol request: " . $e->{'mol_request'}
              if $e->{'mol_request'} ne 'null'
                  and $e->{'mol_request'} ne '{}'
                  and not $e->{is_validated};
        }

    }

    $app->post_run();
}

# main
main();
__END__
