#!/bin/bash

ColorGreen='\e[0;32m'
ColorRed='\e[0;31m'
ColorEnd='\e[0m'
function color_echo {
    OK=$1
    MSG=$2

     COLOR=$ColorGreen
     if [ "$OK" != 1 ]; then
         COLOR=$ColorRed
     fi

     echo -e "${COLOR}${MSG}${ColorEnd}"
}


URL=$( git config --get remote.origin.url );
if ! [[ "$URL" =~ (git+ssh://)?git@github.yandex-team.ru[/:]partner/partner2.git ]]; then
    color_echo 0 "You must go inside 'partner2' checked out folder"
    exit 1;
fi

RELEASE=$1
shift
if ! [[ "$RELEASE" =~ ^[0-9]+$ ]]; then
    color_echo 0 "Release Id should be a number"
    exit 1;
fi


FOUND=0;
COUNT=1;
for TICKET in $@; do
    echo -ne "$COUNT. $TICKET\n"
    for STAGE in before_release after_release; do
        echo -en "\t$STAGE "

        DEST="./migrations/$STAGE/release_${RELEASE}.sql"
        if ! [ -e $DEST ]; then
            echo -e "use partner;\n" >> $DEST
        fi

        if [ -e ./migrations/$STAGE/${TICKET}*.sql ]; then
            if (( $( grep -c "/\* ${TICKET} " $DEST ) == 0 )); then
                for FILE in $( ls -1 ./migrations/$STAGE/${TICKET}* ); do

                    echo -e "\t$FILE"

                    echo "" >> $DEST
                    echo "/* ${TICKET} start */" >> $DEST
                    cat $FILE | grep -v "/\* ${TICKET} " >> $DEST
                    echo "/* ${TICKET} end */" >> $DEST
                    echo "" >> $DEST

                    mkdir -p ./migrations/$STAGE/released/$RELEASE
                    git mv $FILE ./migrations/$STAGE/released/$RELEASE/

                    FOUND=1

                    color_echo 1 "\tOK"

                done
            else
                color_echo 0 "\t added already !! add manualy !! "
            fi
        else
            color_echo 0 "\t not found"
        fi

        if [ "$FOUND" -eq 0 ]; then
            rm $DEST;
        else
            git add $DEST
        fi

    done
    COUNT=$((COUNT+1));
done
