import sys
import json


def get_list_with_placeholders(stage):
    placeholders_list = {
        'annotations': [
            'stagectl_epoch',
            {
                'stagectl_vcs': [
                    'svn_branch',
                    'svn_revision',
                    'svn_tag'
                ]
            }
        ],
        'labels': [
            'notifications_last_timestamp',
            {
                'du_sidecar_target_revision': {
                    'Backend':
                        [
                            'logbrokerToolsLayer',
                            'podBin'
                        ],
                    'Crons':
                        [
                            'logbrokerToolsLayer',
                            'podBin'
                        ],
                    'Hourglass':
                        [
                            'logbrokerToolsLayer',
                            'podBin'
                        ]
                }
            }
        ],
        'spec': [
            {
                'deploy_units': {
                    'Backend': [
                        {
                            'images_for_boxes': {
                                'FrontendNode': 'tag',
                                'JavaAppINTAPI': 'tag',
                                'JavaAppJSONAPI': 'tag',
                                'PerlApp': 'tag',
                            }
                        },
                        {
                            'pod_agent_sandbox_info': 'revision'
                        },
                        'revision'
                    ],
                    'Crons': [
                        {
                            'images_for_boxes': {
                                'CronApp': 'tag'
                            }
                        },
                        {
                            'pod_agent_sandbox_info': 'revision'
                        },
                        'revision'
                    ],
                    'Hourglass': [
                        {
                            'images_for_boxes': {
                                'Haproxy': 'tag',
                                'JavaAppHourglass': 'tag'
                            }
                        },
                        {
                            'pod_agent_sandbox_info': 'revision'
                        },
                        'revision'
                    ]
                }
            },
            'revision',
            {
                'revision_info': 'description'
            }
        ]
    }

    if stage == 'preprod':
        placeholders_list['labels'][1]['du_sidecar_target_revision']['Database'] = 'podBin'
        placeholders_list['spec'][0]['deploy_units']['Database'] = [
            {
                'images_for_boxes': {
                    'MySQL': 'tag',
                }
            },
            {
                'pod_agent_sandbox_info': 'revision'
            },
            'revision'
        ]

    return placeholders_list


def insert_placeholders(placeholders, data):
    if isinstance(placeholders, dict):
        for key, value in placeholders.items():
            insert_placeholders(value, data[key])
    elif isinstance(placeholders, list):
        for item in placeholders:
            insert_placeholders(item, data)
    else:
        data[placeholders] = '%s'


def add_placeholders(deploy_config, stage):
    placeholders = get_list_with_placeholders(stage)
    insert_placeholders(placeholders, deploy_config)

    workloads = (deploy_config['spec']['deploy_units']['Backend']['multi_cluster_replica_set']
    ['replica_set']['pod_template_spec']['spec']
    ['pod_agent_payload']['spec']['workloads'])

    for workload in workloads:
        if workload['box_ref'] == 'FrontendNode':
            envs = workload['env']
            for env in envs:
                if env['name'] == 'ADFOX_HOST':
                    env['value']['literal_env']['value'] = '%s'


file = sys.argv[1]
stage = sys.argv[2]

with open(file, 'r+') as data_file:
    deploy_config = json.load(data_file)

add_placeholders(deploy_config, stage)

with open(file, 'w') as data_file:
    json.dump(deploy_config, data_file, indent=3, separators=(',', ' : '), sort_keys=True)
