#!/usr/bin/perl -w

=encoding UTF-8

=head1 DESCRIPTION

    The script builds a docker image for backend.

=head1 USAGE

    ./bin/deploy/build_perl_backend_docker_image.pl
    ./bin/deploy/build_perl_backend_docker_image.pl --branch=PI-17728_build_images
    ./bin/deploy/build_perl_backend_docker_image.pl --branch=PI-17728_build_images --version=0.0.7

=head1 OPTIONS

    branch  - A branch or a tag (default: a current branch)
    version - A version of docker image (default: experimental-<LOGIN>-0.0.<DATETIME>)

=cut

use lib::abs qw(../../lib);

use qbit;

use Pod::Usage;
use Getopt::Long qw();

main();

sub main {
    my $args = _get_args();

    run_shell('git fetch -p');

    if (defined($args->{'branch'})) {
        run_shell("git checkout $args->{'branch'}");
    }

    run_shell("BACKEND_DOCKER_IMAGE_VERSION=$args->{'version'} make --no-print-directory docker_backend_build");

    print "#END\n";
}

sub _get_args {
    my $args = {};

    my $result = Getopt::Long::GetOptions(
        'branch:s'  => \$args->{'branch'},
        'version:s' => \$args->{'version'},
        'help|?|h'  => \$args->{'help'},
    );

    if (!$result || $args->{'help'}) {
        pod2usage(-verbose => 2, -noperldoc => 1);
    }

    if (!defined($args->{'version'}) || length($args->{'version'}) == 0) {
        my @date = localtime();
        $date[5] += 1900;

        my $version = sprintf("%4d%02d%02d%02d%02d%02d", reverse(@date[0 .. 5]));

        $args->{'version'} = "experimental-$ENV{'USER'}-0.0.$version";
    }

    return $args;
}
